/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.Stack;
import org.multiverse.transactional.refs.IntRef;

public class StackTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    public Transaction startUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void testClearEmptyStack() {
        Stack stack = new Stack();
        stack.clear();
        Assert.assertEquals((long)0L, (long)stack.size());
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testClearNonEmptyStack() {
        Stack<String> stack = new Stack<String>();
        stack.push("a");
        stack.push("b");
        stack.push("c");
        stack.clear();
        Assert.assertEquals((long)0L, (long)stack.size());
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testEmptyStack() {
        Transaction t1 = this.startUpdateTransaction();
        Stack stack = new Stack();
        Assert.assertTrue((boolean)stack.isEmpty());
        t1.commit();
        Transaction t2 = this.startUpdateTransaction();
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testNonEmpty() {
        Transaction t1 = this.startUpdateTransaction();
        IntRef v1 = new IntRef(10);
        IntRef v2 = new IntRef(10);
        Stack<IntRef> stack = new Stack<IntRef>();
        stack.push(v1);
        stack.push(v2);
        t1.commit();
    }

    @Test
    public void test() {
        IntRef v1 = new IntRef(10);
        IntRef v2 = new IntRef(10);
        Transaction t2 = this.startUpdateTransaction();
        Stack<IntRef> stack = new Stack<IntRef>();
        stack.push(v1);
        stack.push(v2);
        t2.commit();
    }

    @Test
    public void testAnotherScenario() {
        Transaction t1 = this.startUpdateTransaction();
        IntRef v1 = new IntRef(10);
        IntRef v2 = new IntRef(10);
        t1.commit();
        Transaction t2 = this.startUpdateTransaction();
        v1.inc();
        Stack<IntRef> stack = new Stack<IntRef>();
        stack.push(v1);
        stack.push(v2);
        t2.commit();
        Transaction t3 = this.startUpdateTransaction();
        Assert.assertEquals((long)11L, (long)v1.get());
        Assert.assertEquals((long)10L, (long)v2.get());
    }
}

