/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.mixins;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTranlocalSnapshot;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.IntRef;
import org.multiverse.stms.alpha.manualinstrumentation.IntRefTranlocal;
import org.multiverse.stms.alpha.mixins.BasicMixin;

public class BasicTransactionalObjectMixinTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void store_initialStore() {
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        DummyTranlocal tranlocal = new DummyTranlocal((AlphaTransactionalObject)txObject);
        txObject.___tryLock(lockOwner);
        int writeVersion = 10;
        txObject.___storeUpdate(tranlocal, writeVersion, false);
        AlphaTranlocal found = txObject.___load();
        Assert.assertSame((Object)((Object)tranlocal), (Object)found);
        Assert.assertEquals((long)writeVersion, (long)tranlocal.getWriteVersion());
    }

    @Test
    public void store_update() {
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        DummyTranlocal tranlocal1 = new DummyTranlocal((AlphaTransactionalObject)txObject);
        txObject.___tryLock(lockOwner);
        txObject.___storeUpdate(tranlocal1, 10L, false);
        txObject.___releaseLock(lockOwner);
        DummyTranlocal tranlocal2 = new DummyTranlocal((AlphaTransactionalObject)txObject);
        txObject.___tryLock(lockOwner);
        txObject.___storeUpdate(tranlocal2, 11L, false);
        txObject.___releaseLock(lockOwner);
        AlphaTranlocal found = txObject.___load();
        Assert.assertSame((Object)((Object)tranlocal2), (Object)found);
        Assert.assertEquals((long)11L, (long)tranlocal2.getWriteVersion());
    }

    @Test
    public void loadUncommitted() {
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        AlphaTranlocal tranlocal = txObject.___load();
        Assert.assertNull((Object)tranlocal);
    }

    @Test
    public void loadLocked() {
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        DummyTranlocal tranlocal = new DummyTranlocal((AlphaTransactionalObject)txObject);
        txObject.___tryLock(lockOwner);
        txObject.___storeUpdate(tranlocal, 10L, false);
        AlphaTranlocal found = txObject.___load();
        Assert.assertSame((Object)((Object)tranlocal), (Object)found);
    }

    @Test
    public void loadCommitted() {
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        DummyTranlocal tranlocal = new DummyTranlocal((AlphaTransactionalObject)txObject);
        txObject.___tryLock(lockOwner);
        txObject.___storeUpdate(tranlocal, 10L, false);
        txObject.___releaseLock(lockOwner);
        AlphaTranlocal found = txObject.___load();
        Assert.assertSame((Object)((Object)tranlocal), (Object)found);
    }

    @Test
    public void loadWithVersion_EqualVersion() {
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        DummyTranlocal tranlocal = new DummyTranlocal((AlphaTransactionalObject)txObject);
        long writeVersion = 10L;
        txObject.___tryLock(lockOwner);
        txObject.___storeUpdate(tranlocal, writeVersion, false);
        txObject.___releaseLock(lockOwner);
        AlphaTranlocal result = txObject.___load(writeVersion);
        Assert.assertSame((Object)((Object)tranlocal), (Object)result);
    }

    @Test
    public void loadWithVersion_WithNewVersion() {
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        DummyTranlocal tranlocal = new DummyTranlocal((AlphaTransactionalObject)txObject);
        long writeVersion = 10L;
        txObject.___tryLock(lockOwner);
        txObject.___storeUpdate(tranlocal, writeVersion, false);
        txObject.___releaseLock(lockOwner);
        AlphaTranlocal result = txObject.___load(writeVersion + 1L);
        Assert.assertSame((Object)((Object)tranlocal), (Object)result);
    }

    @Test
    public void loadWithVersion_uncommittedData() {
        DummyFastTransactionalObjectMixin object = new DummyFastTransactionalObjectMixin();
        AlphaTranlocal result = object.___load(1L);
        Assert.assertNull((Object)result);
    }

    @Test
    public void loadWithVersion_tooNewVersion() {
        IntRef txObject = new IntRef(0);
        long version = this.stm.getVersion();
        txObject.inc();
        try {
            txObject.___load(version);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
    }

    @Test
    public void loadWithVersion_whileLockedFailsIfCommittedVersionEqualToReadVersion() {
        IntRef ref = new IntRef(0);
        long readVersion = this.stm.getVersion();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        IntRefTranlocal readonly = (IntRefTranlocal)ref.___load();
        ref.___tryLock(owner);
        AlphaTranlocal found = ref.___load(readVersion);
        Assert.assertSame((Object)((Object)readonly), (Object)found);
        ref.___releaseLock(owner);
        Assert.assertSame((Object)((Object)readonly), (Object)ref.___load());
    }

    @Test
    public void loadWithVersion_whileLockedFailsIfTheCommittedVersionIsOlderThanReadVersion() {
        IntRef ref = new IntRef(0);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long readVersion = this.stm.getVersion() + 1L;
        try {
            ref.___load(readVersion);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
    }

    @Test
    public void loadWithVersion_whenLockedFailsIfTheCommittedVersionIsNewerThanReadVersion() {
        IntRef ref = new IntRef(0);
        long readVersion = this.stm.getVersion();
        ref.inc();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        try {
            ref.___load(readVersion);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
    }

    @Test
    public void tryLock_succeedsIfLockIsFree() {
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        boolean result = txObject.___tryLock(lockOwner);
        Assert.assertTrue((boolean)result);
        Assert.assertSame((Object)lockOwner, (Object)txObject.___getLockOwner());
    }

    @Test
    public void tryLock_reentrantLockFails() {
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        txObject.___tryLock(owner);
        boolean result = txObject.___tryLock(owner);
        Assert.assertFalse((boolean)result);
        Assert.assertSame((Object)owner, (Object)txObject.___getLockOwner());
    }

    @Test
    public void tryLock_failsIfLockOwnedByOthers() {
        Transaction oldOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        txObject.___tryLock(oldOwner);
        Transaction newOwner = (Transaction)Mockito.mock(Transaction.class);
        boolean result = txObject.___tryLock(newOwner);
        Assert.assertFalse((boolean)result);
        Assert.assertSame((Object)oldOwner, (Object)txObject.___getLockOwner());
    }

    @Test
    public void releaseLock_whenLockIsOwnedLockIsFreed() {
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        txObject.___tryLock(owner);
        txObject.___releaseLock(owner);
        Assert.assertNull((Object)txObject.___getLockOwner());
    }

    @Test
    public void releaseLock_whenLockIsFreeCallIsIgnored() {
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        txObject.___releaseLock(owner);
        Assert.assertNull((Object)txObject.___getLockOwner());
    }

    @Test
    public void releaseLock_whenLockIsNotOwnedCallIsIgnored() {
        Transaction otherOwner = (Transaction)Mockito.mock(Transaction.class);
        Transaction thisOwner = (Transaction)Mockito.mock(Transaction.class);
        DummyFastTransactionalObjectMixin txObject = new DummyFastTransactionalObjectMixin();
        txObject.___tryLock(otherOwner);
        txObject.___releaseLock(thisOwner);
        Assert.assertSame((Object)otherOwner, (Object)txObject.___getLockOwner());
    }

    static class DummyTranlocal
    extends AlphaTranlocal {
        DummyTranlocal(AlphaTransactionalObject transactionalObject) {
            this.___transactionalObject = transactionalObject;
        }

        public AlphaTranlocal openForWrite() {
            throw new RuntimeException();
        }

        public AlphaTranlocalSnapshot takeSnapshot() {
            throw new RuntimeException();
        }

        public boolean isDirty() {
            throw new RuntimeException();
        }
    }

    static class DummyFastTransactionalObjectMixin
    extends BasicMixin {
        DummyFastTransactionalObjectMixin() {
        }

        public AlphaTranlocal ___openUnconstructed() {
            throw new RuntimeException();
        }
    }
}

