/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRefTranlocal;

public class AlphaProgrammaticLongRef_incTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNoTransactionOnThreadLocal() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        long version = this.stm.getVersion();
        ref.inc(1L);
        Assert.assertEquals((long)11L, (long)ref.atomicGet());
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        AlphaTranlocal committed = ref.___load();
        Assert.assertNotNull((Object)committed);
        Assert.assertTrue((boolean)committed.isCommitted());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertEquals((long)(version + 1L), (long)committed.getWriteVersion());
    }

    @Test
    public void whenNoTransactionAndNoChange() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        AlphaProgrammaticLongRefTranlocal committed = (AlphaProgrammaticLongRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        ref.inc(0L);
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)committed, (Object)ref.___load());
        Assert.assertTrue((boolean)committed.isCommitted());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertEquals((long)version, (long)committed.getWriteVersion());
    }

    @Test
    public void whenNotTransactionAndCommittedBefore_thenUncommittedReadConflict() {
        AlphaProgrammaticLongRef ref = AlphaProgrammaticLongRef.createUncommitted((AlphaStm)this.stm);
        long version = this.stm.getVersion();
        try {
            ref.inc(10L);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenTransactionOnThreadLocal_thenItIsUsed() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setReadTrackingEnabled(true).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        long version = this.stm.getVersion();
        ref.inc(5L);
        tx.abort();
        Assert.assertEquals((long)10L, (long)ref.atomicGet());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)version, (long)ref.___load().getWriteVersion());
    }
}

