/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;

public class AlphaProgrammaticLongRef_sharedAtomicLongStressTest {
    private final AtomicLong ref = new AtomicLong();
    private int threadCount = 4;
    private volatile boolean stop;
    private boolean strict = false;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = this.sum((AtomicIncThread[])threads);
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    private long sum(AtomicIncThread[] threads) {
        long result = 0L;
        for (AtomicIncThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    private AtomicIncThread[] createThreads() {
        AtomicIncThread[] threads = new AtomicIncThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            threads[k] = new AtomicIncThread(k);
        }
        return threads;
    }

    public class AtomicIncThread
    extends TestThread {
        private long count;

        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
        }

        public long get() {
            return AlphaProgrammaticLongRef_sharedAtomicLongStressTest.this.ref.get();
        }

        public void doRun() throws Exception {
            while (!AlphaProgrammaticLongRef_sharedAtomicLongStressTest.this.stop) {
                if (AlphaProgrammaticLongRef_sharedAtomicLongStressTest.this.strict) {
                    AlphaProgrammaticLongRef_sharedAtomicLongStressTest.this.ref.incrementAndGet();
                } else {
                    long get = AlphaProgrammaticLongRef_sharedAtomicLongStressTest.this.ref.get();
                    AlphaProgrammaticLongRef_sharedAtomicLongStressTest.this.ref.compareAndSet(get, get + 1L);
                }
                if (this.count % 10000000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }
    }
}

