/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;

public class AlphaProgrammaticRef_atomicSetTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNullAndNewValueNull() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef();
        long version = this.stm.getVersion();
        String result = (String)ref.atomicSet(null);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void whenNotNullAndNewValueNull() {
        String oldValue = "old";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)"old");
        long version = this.stm.getVersion();
        String newValue = "foo";
        String result = (String)ref.atomicSet((Object)newValue);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newValue, (Object)ref.get());
    }

    @Test
    public void whenNotNullAndValueNull() {
        String oldValue = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldValue);
        long version = this.stm.getVersion();
        String result = (String)ref.atomicSet(null);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void testSetChangedReferenced() {
        String oldValue = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldValue);
        long version = this.stm.getVersion();
        String newRef = "bar";
        String result = (String)ref.atomicSet((Object)newRef);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetUnchangedReferences() {
        String oldValue = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldValue);
        long version = this.stm.getVersion();
        String result = (String)ref.atomicSet((Object)oldValue);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldValue, (Object)ref.get());
    }

    @Test
    public void testSetEqualIsNotUsedButReferenceEquality() {
        String oldValue = new String("foo");
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldValue);
        long version = this.stm.getVersion();
        String newValue = new String("foo");
        String result = (String)ref.set((Object)newValue);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newValue, (Object)ref.get());
    }

    @Test
    public void testSetAndUnsetIsNotSeenAsChange() {
        String oldValue = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldValue);
        long version = this.stm.getVersion();
        Transaction tx = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        String newRef = "bar";
        ref.set((Object)newRef);
        ref.set((Object)oldValue);
        tx.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldValue, (Object)ref.get());
    }
}

