/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MapReadonlyAlphaTransaction_abortTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapReadonlyAlphaTransaction createSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new MapReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenUsed() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long expectedVersion = this.stm.getVersion();
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)expectedTranlocal), (Object)ref.___load());
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenUnused() {
        long expectedVersion = this.stm.getVersion();
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }
}

