/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MonoReadonlyAlphaTransaction_commitTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createFastConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoReadonlyAlphaTransaction createSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new MonoReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        MonoReadonlyAlphaTransaction tx = this.createSutTransaction();
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenUsed() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenPrepared_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.prepare();
        long version = this.stm.getVersion();
        tx.commit();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenConflict_thenCommitSucceeds() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.get(this.stm));
    }
}

