/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_commitTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public NonTrackingReadonlyAlphaTransaction createSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, false);
        return new NonTrackingReadonlyAlphaTransaction(config);
    }

    @Test
    public void commitDoesNotLockTransactionalObjects() {
        ManualRef ref = new ManualRef(this.stm);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.resetLockInfo();
        tx.commit();
        ref.assertNoLockAcquired();
        ref.assertNoLocksReleased();
    }

    @Test
    public void whenUnused() {
        long startVersion = this.stm.getVersion();
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenUsed() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long startVersion = this.stm.getVersion();
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.commit();
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenConflictingChangesAreMade_thenCommitSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        long startVersion = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
    }
}

