/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_openForReadTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public NonTrackingReadonlyAlphaTransaction createSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, false).withMaxRetries(10);
        return new NonTrackingReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenOpenedForRead_thenNotLockTxObjects() {
        ManualRef ref = new ManualRef(this.stm);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        ref.resetLockInfo();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void openedForReadWithNull_thenNullReturned() {
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal result = tx.openForRead(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict uncommittedReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenVersionExactMatch() {
        ManualRef ref = new ManualRef(this.stm, 10);
        ManualRefTranlocal expected = (ManualRefTranlocal)ref.___load(this.stm.getVersion());
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found.isCommitted());
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
    }

    @Test
    public void whenVersionIsOlder() {
        ManualRef ref = new ManualRef(this.stm, 10);
        AlphaTranlocal committed = ref.___load();
        this.stmConfig.clock.tick();
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)committed, (Object)tranlocal);
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal);
    }

    @Test
    public void whenLockedAndVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        this.stm.getClock().tick();
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenOtherTransactionHasPendingWrite_noChangesAreSeen() {
        ManualRef ref = new ManualRef(this.stm, 0);
        NonTrackingReadonlyAlphaTransaction readonlyTx = this.createSutTransaction();
        AlphaTransaction updateTx = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)updateTx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        ManualRefTranlocal read = (ManualRefTranlocal)readonlyTx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertEquals((long)0L, (long)read.value);
    }

    @Test
    public void whenVersionTooOld_thenLoadTooOldVersionException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        NonTrackingReadonlyAlphaTransaction readonlyTx = this.createSutTransaction();
        AlphaTransaction updateTx = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)updateTx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        ManualRefTranlocal found = (ManualRefTranlocal)readonlyTx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertEquals((long)0L, (long)found.value);
        updateTx.commit();
        try {
            readonlyTx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (PreparedTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef value = new ManualRef(this.stm, 10);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)value);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

