/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_resetTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public NonTrackingReadonlyAlphaTransaction createSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, false);
        return new NonTrackingReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenUnusedAndNoOtherUpdates() {
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenUnusedAndOtherUpdates() {
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        this.stmConfig.clock.tick();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenPrepared() {
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        this.stmConfig.clock.tick();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenAborted() {
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        this.stmConfig.clock.tick();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenCommitted() {
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        this.stmConfig.clock.tick();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }
}

