/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_openForCommutingWriteTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction createSutTransaction(int size) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    public AlphaTransaction createSutTransaction(int size, int maximumSize) {
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(maximumSize);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(speculativeConfig);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    @Test
    public void whenTransactionalObjectLocked() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 10L);
        AlphaTransaction tx = this.createSutTransaction(10);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        AlphaTranlocal loaded = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)loaded.isCommuting());
    }

    @Test
    public void whenTransactionalObjectAlreadyOpenedForConstruction() {
        AlphaProgrammaticLongRef ref = AlphaProgrammaticLongRef.createUncommitted((AlphaStm)this.stm);
        AlphaTransaction tx = this.createSutTransaction(10);
        AlphaTranlocal openedForConstruction = tx.openForConstruction((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForConstruction, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenTransactionalObjectAlreadyOpenedForWrite() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 1L);
        AlphaTransaction tx = this.createSutTransaction(10);
        AlphaTranlocal openedForWrite = tx.openForWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertEquals((long)0L, (long)found.getWriteVersion());
    }

    @Test
    public void whenTransactionalObjectAlreadyOpenedForRead() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 1L);
        AlphaTransaction tx = this.createSutTransaction(10);
        AlphaTranlocal openedForRead = tx.openForRead((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertNotNull((Object)found);
        Assert.assertFalse((openedForRead == found ? 1 : 0) != 0);
        Assert.assertSame((Object)openedForRead, (Object)found.getOrigin());
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertEquals((long)0L, (long)found.getWriteVersion());
    }

    @Test
    public void whenTransactionalObjectAlreadyOpenedForCommutingWrite() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 1L);
        AlphaTransaction tx = this.createSutTransaction(10);
        AlphaTranlocal firstOpen = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)found, (Object)firstOpen);
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertTrue((boolean)found.isCommuting());
        Assert.assertEquals((long)-2L, (long)found.getWriteVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction(10);
        tx.commit();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction(10);
        tx.abort();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction(10);
        tx.prepare();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

