/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionConfiguration;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionFactoryBuilder;
import org.multiverse.stms.AbstractTransactionConfiguration;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;
import org.multiverse.templates.TransactionTemplate;

public class ArrayUpdateAlphaTransaction_writeSkewStressTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    public AlphaTransaction createSutTransaction(int size, boolean writeSkewAllowed) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withReadTrackingEnabled(true).withWriteSkewAllowed(writeSkewAllowed);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    @Test
    public void testConcurrent() {
        ManualRef account1 = new ManualRef(this.stm);
        ManualRef account2 = new ManualRef(this.stm);
        ManualRef account3 = new ManualRef(this.stm);
        ManualRef account4 = new ManualRef(this.stm);
        account1.set(this.stm, 1000);
        TransferThread t1 = new TransferThread(0, account1, account2, account3, account4, true);
        TransferThread t2 = new TransferThread(0, account3, account4, account1, account2, true);
        TestUtils.startAll((TestThread[])new TestThread[]{t1, t2});
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        System.out.println("account1 " + account1.get(this.stm));
        System.out.println("account2 " + account2.get(this.stm));
        System.out.println("account3 " + account3.get(this.stm));
        System.out.println("account4 " + account4.get(this.stm));
        Assert.assertTrue((account1.get(this.stm) + account2.get(this.stm) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((account3.get(this.stm) + account4.get(this.stm) >= 0 ? 1 : 0) != 0);
    }

    public void testConcurrentWithWriteSkewAllowed() {
        ManualRef accountA1 = new ManualRef(this.stm);
        ManualRef accountA2 = new ManualRef(this.stm);
        ManualRef accountB1 = new ManualRef(this.stm);
        ManualRef accountB2 = new ManualRef(this.stm);
        accountA1.set(this.stm, 1000);
        accountB1.set(this.stm, 1000);
        TransferThread thread1 = new TransferThread(0, accountA1, accountA2, accountB1, accountB1, true);
        TransferThread thread2 = new TransferThread(0, accountB1, accountB2, accountA1, accountA1, true);
        TestUtils.startAll((TestThread[])new TestThread[]{thread1, thread2});
        TestUtils.joinAll((TestThread[])new TestThread[]{thread1, thread2});
        System.out.println("account1 " + accountA1.get(this.stm));
        System.out.println("account2 " + accountA2.get(this.stm));
        System.out.println("account3 " + accountB1.get(this.stm));
        System.out.println("account4 " + accountB2.get(this.stm));
        boolean accountAViolation = accountA1.get(this.stm) + accountA2.get(this.stm) < 0;
        boolean accountBViolation = accountB1.get(this.stm) + accountB2.get(this.stm) < 0;
        Assert.assertTrue((accountAViolation || accountBViolation ? 1 : 0) != 0);
    }

    public ManualRef random(ManualRef ref1, ManualRef ref2) {
        return TestUtils.randomBoolean() ? ref1 : ref2;
    }

    public class TransferThread
    extends TestThread {
        final ManualRef accountFrom1;
        final ManualRef accountFrom2;
        final ManualRef accountTo1;
        final ManualRef accountTo2;
        final boolean writeSkewAllowed;

        public TransferThread(int id, ManualRef accountFrom1, ManualRef accountFrom2, ManualRef accountTo1, ManualRef accountTo2, boolean writeSkewAllowed) {
            super("TransferThread-" + id);
            this.accountFrom1 = accountFrom1;
            this.accountFrom2 = accountFrom2;
            this.accountTo1 = accountTo1;
            this.accountTo2 = accountTo2;
            this.writeSkewAllowed = writeSkewAllowed;
        }

        public void doRun() throws Exception {
            TransactionFactory txFactory = new TransactionFactory(){

                public TransactionConfiguration getTransactionConfiguration() {
                    return new AbstractTransactionConfiguration();
                }

                public Stm getStm() {
                    return ArrayUpdateAlphaTransaction_writeSkewStressTest.this.stm;
                }

                public TransactionFactoryBuilder getTransactionFactoryBuilder() {
                    return null;
                }

                public Transaction start() {
                    AlphaTransaction tx = this.create();
                    tx.start();
                    return tx;
                }

                public AlphaTransaction create() {
                    return ArrayUpdateAlphaTransaction_writeSkewStressTest.this.createSutTransaction(10, TransferThread.this.writeSkewAllowed);
                }
            };
            for (int k = 0; k < 1000; ++k) {
                new TransactionTemplate(txFactory){

                    public Object execute(Transaction t) throws Exception {
                        AlphaTransaction tx = (AlphaTransaction)t;
                        ManualRefTranlocal tranlocalAccountFrom1 = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)TransferThread.this.accountFrom1);
                        ManualRefTranlocal tranlocalAccountFrom2 = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)TransferThread.this.accountFrom2);
                        TestUtils.sleepRandomMs((int)100);
                        if (tranlocalAccountFrom1.value + tranlocalAccountFrom2.value >= 100) {
                            ManualRef from = ArrayUpdateAlphaTransaction_writeSkewStressTest.this.random(TransferThread.this.accountFrom1, TransferThread.this.accountFrom2);
                            ManualRefTranlocal tranlocalFrom = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)from);
                            tranlocalFrom.value -= 100;
                            ManualRef to = ArrayUpdateAlphaTransaction_writeSkewStressTest.this.random(TransferThread.this.accountTo1, TransferThread.this.accountTo2);
                            ManualRefTranlocal tranlocalTo = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)to);
                            tranlocalTo.value += 100;
                            TransferThread.this.assert2WritesAndOneRead(tx, TransferThread.this.accountFrom1, TransferThread.this.accountFrom2, to);
                        }
                        return null;
                    }
                }.execute();
            }
        }

        private void assert2WritesAndOneRead(AlphaTransaction tx, ManualRef from1, ManualRef from2, ManualRef to) {
            int firstFreeIndex = (Integer)TestUtils.getField((Object)tx, (String)"firstFreeIndex");
            Assert.assertEquals((long)3L, (long)firstFreeIndex);
            AlphaTranlocal[] attached = (AlphaTranlocal[])TestUtils.getField((Object)tx, (String)"attachedArray");
            AlphaTranlocal from1Tranlocal = this.find(attached, firstFreeIndex, from1);
            AlphaTranlocal from2Tranlocal = this.find(attached, firstFreeIndex, from2);
            Assert.assertTrue((from1Tranlocal.isCommitted() || from2Tranlocal.isCommitted() ? 1 : 0) != 0);
            Assert.assertTrue((!from1Tranlocal.isCommitted() || !from2Tranlocal.isCommitted() ? 1 : 0) != 0);
            AlphaTranlocal write2 = this.find(attached, firstFreeIndex, to);
            Assert.assertFalse((boolean)write2.isCommitted());
        }

        public AlphaTranlocal find(AlphaTranlocal[] attached, int firstFreeIndex, ManualRef ref) {
            for (int k = 0; k < firstFreeIndex; ++k) {
                if (attached[k].getTransactionalObject() != ref) continue;
                return attached[k];
            }
            return null;
        }
    }
}

