/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MapUpdateAlphaTransaction_resetTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapUpdateAlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MapUpdateAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenUsed() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenAborted() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenPreparedWithLockedResources_thenResourcesFreed() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.prepare();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenCommitted() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenVersionUpdatedByOtherTx_thenTxUpdatesReadVersion() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        this.stmConfig.clock.tick();
        tx.reset();
        TestUtils.assertIsNew((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenReadWriteMapNonEmpty_thenItIsCleared() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForWrite((AlphaTransactionalObject)ref2);
        tx.reset();
        Map readWriteMap = (Map)TestUtils.getField((Object)tx, (String)"attachedMap");
        Assert.assertTrue((boolean)readWriteMap.isEmpty());
    }
}

