/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MonoUpdateAlphaTransaction_openForReadTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoUpdateAlphaTransaction createSutTransaction(SpeculativeConfiguration speculativeConfig) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withMaxRetries(10).withSpeculativeConfiguration(speculativeConfig);
        return new MonoUpdateAlphaTransaction(config);
    }

    public MonoUpdateAlphaTransaction createSutTransaction() {
        return this.createSutTransaction(new SpeculativeConfiguration(100));
    }

    public MonoUpdateAlphaTransaction createSutTransactionWithoutAutomaticReadTracking() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withMaxRetries(10).withExplictRetryAllowed(false).withReadTrackingEnabled(false);
        return new MonoUpdateAlphaTransaction(config);
    }

    @Test
    public void testAutomaticReadTrackingProperty() {
        MonoUpdateAlphaTransaction tx = this.createSutTransactionWithoutAutomaticReadTracking();
        Assert.assertFalse((boolean)tx.getConfiguration().isReadTrackingEnabled());
        tx = this.createSutTransaction();
        Assert.assertTrue((boolean)tx.getConfiguration().isReadTrackingEnabled());
    }

    @Test
    public void whenAutomaticReadTrackingDisabled_openForReadIsNotTracked() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransactionWithoutAutomaticReadTracking();
        tx.openForRead((AlphaTransactionalObject)ref);
        AlphaTranlocal tranlocal = (AlphaTranlocal)TestUtils.getField((Object)tx, (String)"attached");
        Assert.assertNull((String)"attached field was not null", (Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenTxObjectNull_thenNullReturned() {
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        AlphaTranlocal tranlocal = tx.openForRead(null);
        Assert.assertNull((Object)tranlocal);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenNotCommittedBefore_thenLoadUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal);
    }

    @Test
    public void whenLockedAndVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        this.stm.getClock().tick();
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenOlderVersionExists_thenOlderVersionReturned() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal committed = ref.___load();
        this.stmConfig.clock.tick();
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)committed, (Object)((Object)found));
        Assert.assertSame((Object)committed, (Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenVersionMatch() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)committed), (Object)((Object)tranlocal));
        Assert.assertSame((Object)((Object)committed), (Object)TestUtils.getField((Object)tx, (String)"attached"));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.inc(this.stm);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenAlreadyOpenedForWrite_thenSameTranlocalReturned() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)tranlocal, (Object)found);
    }

    @Test
    public void whenAlreadyOpenedForCommutingWrite_thenPrematureFixation() {
        AlphaProgrammaticLongRef ref1 = new AlphaProgrammaticLongRef(this.stm, 0L);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForCommutingWrite((AlphaTransactionalObject)ref1);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref1);
        Assert.assertSame((Object)tranlocal, (Object)found);
        Assert.assertFalse((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedButVersionMatches() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        ref.atomicInc(10L);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)this.stm.getVersion(), (long)version);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)openedForCommutingWrite.isCommuting());
    }

    @Test
    public void whenAlreadyOpenedForConstruction_thenSameTranlocalReturned() {
        ManualRef ref1 = ManualRef.createUncommitted();
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForConstruction((AlphaTransactionalObject)ref1);
        AlphaTranlocal found = tx.openForCommutingWrite((AlphaTransactionalObject)ref1);
        Assert.assertSame((Object)tranlocal, (Object)found);
        Assert.assertFalse((boolean)tranlocal.isCommuting());
    }

    @Test
    public void whenMaximumCapacityExceeded_thenSpeculativeConfigurationFailure() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(100);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction(speculativeConfig);
        tx.openForRead((AlphaTransactionalObject)ref1);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref2);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)2L, (long)speculativeConfig.getOptimalSize());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

