/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;

public class TransactionTemplate_constructionTest {
    private Stm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void testNoArg() {
        TransactionTemplate t = new TransactionTemplate(){

            public Object execute(Transaction tx) throws Exception {
                return null;
            }
        };
        Assert.assertNotNull((Object)t.getTransactionFactory());
        Assert.assertTrue((boolean)t.isThreadLocalAware());
        Assert.assertTrue((boolean)t.isLifecycleListenersEnabled());
    }

    @Test
    public void testWithTxFactory() {
        TransactionFactory factory = this.stm.getTransactionFactoryBuilder().build();
        TransactionTemplate t = new TransactionTemplate(factory){

            public Object execute(Transaction tx) throws Exception {
                return null;
            }
        };
        Assert.assertSame((Object)factory, (Object)t.getTransactionFactory());
        Assert.assertTrue((boolean)t.isThreadLocalAware());
        Assert.assertTrue((boolean)t.isLifecycleListenersEnabled());
    }
}

