/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_toStringTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNoElements() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(0);
        String result = array.toString();
        Assert.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void whenSomeElements() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(3);
        array.set(0, (Object)"zero");
        array.set(1, (Object)"one");
        array.set(2, (Object)"two");
        String result = array.toString();
        Assert.assertEquals((Object)"[zero, one, two]", (Object)result);
    }

    @Test
    public void whenNullElement() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(1);
        String result = array.toString();
        Assert.assertEquals((Object)"[null]", (Object)result);
    }
}

