/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_removeObjectTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenEmpty_returnFalse() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        boolean changed = list.remove((Object)"foo");
        Assert.assertFalse((boolean)changed);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenItemNotFound_returnFalse() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        boolean changed = list.remove((Object)"foo");
        Assert.assertFalse((boolean)changed);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenObjectNull_thenRemovalAlsoSucces() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", null, "c"});
        long version = this.stm.getVersion();
        boolean changed = list.remove(null);
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, c]", (Object)list.toString());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void whenObjectFound_thenRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        long version = this.stm.getVersion();
        boolean changed = list.remove((Object)"b");
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, c]", (Object)list.toString());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void whenMultipleOccurrences_thenOnlyFirstRemoved() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c", "b"});
        long version = this.stm.getVersion();
        boolean changed = list.remove((Object)"b");
        Assert.assertTrue((boolean)changed);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)"[a, c, b]", (Object)list.toString());
        Assert.assertEquals((long)3L, (long)list.size());
    }
}

