/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_miscStressTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void longRunningTasksCanRunParallel() throws ExecutionException, InterruptedException {
        TransactionalThreadPoolExecutor executor = new TransactionalThreadPoolExecutor();
        executor.setCorePoolSize(2);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                System.out.println("Start " + System.identityHashCode(Thread.currentThread()));
                TestUtils.sleepMs((long)5000L);
                System.out.println("Finished " + System.identityHashCode(Thread.currentThread()));
            }
        };
        Future future1 = executor.submit(task);
        Future future2 = executor.submit(task);
        future1.get();
        future2.get();
        TestUtils.testIncomplete();
    }

    @Test
    public void executeIsAtomic() {
        TransactionalThreadPoolExecutor executor = new TransactionalThreadPoolExecutor();
        Runnable command = (Runnable)Mockito.mock(Runnable.class);
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        executor.execute(command);
        executor.execute(command);
        t.abort();
        TransactionalThreadPoolExecutorTestUtils.assertIsUnstarted(executor);
        TestUtils.testIncomplete();
    }
}

