/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutorTestUtils;

public class TransactionalThreadPoolExecutor_setCorePoolSizeTest {
    private Stm stm;
    private TransactionalThreadPoolExecutor executor;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.awaitTerminationUninterruptibly();
        }
    }

    @Test
    public void whenUnstarted() {
        this.executor = new TransactionalThreadPoolExecutor();
        long version = this.stm.getVersion();
        this.executor.setCorePoolSize(10);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        TransactionalThreadPoolExecutorTestUtils.assertIsUnstarted(this.executor);
        Assert.assertEquals((long)10L, (long)this.executor.getCorePoolSize());
        Assert.assertEquals((long)0L, (long)this.executor.getCurrentPoolSize());
    }

    @Test
    public void whenValueSmallerThanZero_thenIllegalArgumentException() {
        this.executor = new TransactionalThreadPoolExecutor();
        long version = this.stm.getVersion();
        try {
            this.executor.setCorePoolSize(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TransactionalThreadPoolExecutorTestUtils.assertIsUnstarted(this.executor);
        Assert.assertEquals((long)1L, (long)this.executor.getCorePoolSize());
        Assert.assertEquals((long)0L, (long)this.executor.getCurrentPoolSize());
    }

    @Test
    public void whenNoChange() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.start();
        this.executor.setCorePoolSize(1);
        TransactionalThreadPoolExecutorTestUtils.assertIsStarted(this.executor);
        Assert.assertEquals((long)1L, (long)this.executor.getCorePoolSize());
    }

    @Test
    @Ignore
    public void whenPoolSizeIncreased() {
        this.executor = new TransactionalThreadPoolExecutor(1);
        this.executor.start();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)2000L);
            }
        };
        this.executor.execute(command);
        this.executor.execute(command);
        TestUtils.sleepMs((long)1000L);
        Assert.assertEquals((long)1L, (long)this.executor.getWorkQueue().size());
        this.executor.setCorePoolSize(2);
        TestUtils.sleepMs((long)5000L);
        Assert.assertEquals((long)0L, (long)this.executor.getWorkQueue().size());
    }

    @Test
    public void whenPoolSizeDecreasedAndWorkersDoingNothing() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.setCorePoolSize(5);
        this.executor.start();
        this.executor.setCorePoolSize(2);
        Assert.assertEquals((long)2L, (long)this.executor.getCorePoolSize());
    }

    @Test
    public void whenPoolSizeDecreasedAndWorkersWorking() {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)1000L);
            }
        };
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.setCorePoolSize(3);
        for (int k = 0; k < 3; ++k) {
            this.executor.execute(command);
        }
        TestUtils.sleepMs((long)500L);
        this.executor.setCorePoolSize(1);
        TestUtils.sleepMs((long)2000L);
        List threads = (List)TestUtils.getField((Object)this.executor, (String)"threads");
        Assert.assertEquals((long)1L, (long)threads.size());
    }

    @Test
    public void whenShutdown_thenIllegalStateException() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TestUtils.sleepMs((long)3000L);
            }
        });
        TestUtils.sleepMs((long)1500L);
        this.executor.shutdown();
        try {
            this.executor.setCorePoolSize(10);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TransactionalThreadPoolExecutorTestUtils.assertIsShutdown(this.executor);
        Assert.assertEquals((long)1L, (long)this.executor.getCorePoolSize());
    }

    @Test
    public void whenTerminated_thenIllegalStateException() {
        this.executor = new TransactionalThreadPoolExecutor();
        this.executor.shutdown();
        try {
            this.executor.setCorePoolSize(10);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.executor.getCorePoolSize());
        TransactionalThreadPoolExecutorTestUtils.assertIsTerminated(this.executor);
    }
}

