/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.refs.CharRef;

public class CharacterRefTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void constructorWithNoArg() {
        CharRef ref = new CharRef();
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        CharRef ref = new CharRef('\n');
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void set() {
        CharRef ref = new CharRef('\n');
        long old = ref.set('d');
        Assert.assertEquals((long)10L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testInc() {
        CharRef ref = new CharRef('d');
        Assert.assertEquals((long)101L, (long)ref.inc());
        Assert.assertEquals((long)101L, (long)ref.get());
        Assert.assertEquals((long)111L, (long)ref.inc('\n'));
        Assert.assertEquals((long)111L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.inc('\ufff5'));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testDec() {
        CharRef ref = new CharRef('d');
        Assert.assertEquals((long)99L, (long)ref.dec());
        Assert.assertEquals((long)99L, (long)ref.get());
        Assert.assertEquals((long)89L, (long)ref.dec('\n'));
        Assert.assertEquals((long)89L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.dec('\ufff5'));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        CharRef ref1 = new CharRef('\n');
        CharRef ref2 = new CharRef('\n');
        CharRef ref3 = new CharRef('\u0014');
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        CharRef ref = new CharRef('\n');
        Assert.assertEquals((long)10L, (long)ref.hashCode());
        ref.set('\u00c8');
        Assert.assertEquals((long)200L, (long)ref.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"CharRef(value=a)", (Object)new CharRef('a').toString());
    }

    @Test
    public void testAtomic() {
        CharRef ref1 = new CharRef('a');
        CharRef ref2 = new CharRef('b');
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)97L, (long)ref1.get());
        Assert.assertEquals((long)98L, (long)ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(CharRef ... refs) {
        for (CharRef ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }

    @Test
    public void awaitTest() {
        final CharRef ref = new CharRef('a');
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                ref.await('c');
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set('b');
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set('c');
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }
}

