/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.refs.BooleanRef;
import org.multiverse.transactional.refs.IntRef;

public class IntRefBlockingStressTest {
    private AlphaStm stm;
    private IntRef ref;
    private BooleanRef completedRef;
    private int consumerCount = 10;
    private int unprocessedCapacity = 1000;
    private volatile boolean stop;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.ref = new IntRef();
        this.completedRef = new BooleanRef();
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            producers[k] = new ProducerThread(k);
        }
        TestThread[] consumers = new ConsumerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
        long produceCount = this.sum((ProducerThread[])producers);
        long consumeCount = this.sum((ConsumerThread[])consumers);
        long leftOver = this.ref.get();
        Assert.assertEquals((long)produceCount, (long)(consumeCount + leftOver));
    }

    long sum(ProducerThread[] threads) {
        long result = 0L;
        for (ProducerThread thread : threads) {
            result += thread.produceCount;
        }
        return result;
    }

    long sum(ConsumerThread[] threads) {
        long result = 0L;
        for (ConsumerThread thread : threads) {
            result += thread.consumeCount;
        }
        return result;
    }

    class ConsumerThread
    extends TestThread {
        long consumeCount;

        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
            this.consumeCount = 0L;
        }

        public void doRun() throws Exception {
            boolean again;
            do {
                again = this.consume();
                if (this.consumeCount % 100000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.consumeCount);
                }
                if (!again) continue;
                ++this.consumeCount;
            } while (again);
        }

        @TransactionalMethod(readonly=false)
        private boolean consume() {
            if (IntRefBlockingStressTest.this.completedRef.get()) {
                return false;
            }
            long value = IntRefBlockingStressTest.this.ref.get();
            if (value == 0L) {
                StmUtils.retry();
            }
            IntRefBlockingStressTest.this.ref.inc(-1);
            return true;
        }
    }

    class ProducerThread
    extends TestThread {
        long produceCount;

        public ProducerThread(int id) {
            super("ProducerThread-" + id);
            this.produceCount = 0L;
        }

        public void doRun() throws Exception {
            while (!IntRefBlockingStressTest.this.stop) {
                if (this.produce()) {
                    ++this.produceCount;
                }
                if (this.produceCount % 100000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.produceCount);
            }
            IntRefBlockingStressTest.this.completedRef.set(true);
        }

        @TransactionalMethod(readonly=false)
        private boolean produce() {
            if (IntRefBlockingStressTest.this.completedRef.get()) {
                return false;
            }
            long value = IntRefBlockingStressTest.this.ref.get();
            if (value >= (long)IntRefBlockingStressTest.this.unprocessedCapacity) {
                StmUtils.retry();
            }
            IntRefBlockingStressTest.this.ref.inc();
            return true;
        }
    }
}

