/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.refs.LongRef;

public class LongRefTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void constructorWithNoArg() {
        LongRef ref = new LongRef();
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void constructorWithSingleArg() {
        LongRef ref = new LongRef(10L);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void set() {
        LongRef ref = new LongRef(10L);
        long old = ref.set(100L);
        Assert.assertEquals((long)10L, (long)old);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testInc() {
        LongRef ref = new LongRef(100L);
        Assert.assertEquals((long)101L, (long)ref.inc());
        Assert.assertEquals((long)101L, (long)ref.get());
        Assert.assertEquals((long)111L, (long)ref.inc(10L));
        Assert.assertEquals((long)111L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.inc(-11L));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testDec() {
        LongRef ref = new LongRef(100L);
        Assert.assertEquals((long)99L, (long)ref.dec());
        Assert.assertEquals((long)99L, (long)ref.get());
        Assert.assertEquals((long)89L, (long)ref.dec(10L));
        Assert.assertEquals((long)89L, (long)ref.get());
        Assert.assertEquals((long)100L, (long)ref.dec(-11L));
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void testEquals() {
        LongRef ref1 = new LongRef(10L);
        LongRef ref2 = new LongRef(10L);
        LongRef ref3 = new LongRef(20L);
        Assert.assertFalse((boolean)ref1.equals(null));
        Assert.assertFalse((boolean)ref1.equals((Object)""));
        Assert.assertTrue((boolean)ref1.equals((Object)ref2));
        Assert.assertTrue((boolean)ref2.equals((Object)ref1));
        Assert.assertTrue((boolean)ref1.equals((Object)ref1));
        Assert.assertFalse((boolean)ref1.equals((Object)ref3));
        Assert.assertFalse((boolean)ref3.equals((Object)ref1));
    }

    @Test
    public void testHashCode() {
        LongRef ref = new LongRef(10L);
        Assert.assertEquals((long)10L, (long)ref.hashCode());
        ref.set(200L);
        Assert.assertEquals((long)200L, (long)ref.hashCode());
    }

    @Test
    public void testAtomic() {
        LongRef ref1 = new LongRef(10L);
        LongRef ref2 = new LongRef(20L);
        try {
            this.incButAbort(ref1, ref2);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref1.get());
        Assert.assertEquals((long)20L, (long)ref2.get());
    }

    @TransactionalMethod
    public void incButAbort(LongRef ... refs) {
        for (LongRef ref : refs) {
            ref.inc();
        }
        ThreadLocalTransaction.getThreadLocalTransaction().abort();
    }

    @Test
    public void await() {
        LongRef txInt = new LongRef();
        SetThread t = new SetThread(txInt, 3);
        t.start();
        txInt.await(3L);
    }

    @Test
    public void awaitTest() {
        final LongRef ref = new LongRef();
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                ref.await(2L);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set(1L);
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        ref.set(2L);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    public class SetThread
    extends TestThread {
        private final LongRef txInt;
        private final int value;

        public SetThread(LongRef txInt, int value) {
            super("SetThread");
            this.txInt = txInt;
            this.value = value;
        }

        public void doRun() throws Exception {
            TestUtils.sleepMs((long)300L);
            this.txInt.set((long)this.value);
        }
    }
}

