/*
 * Decompiled with CFR 0.152.
 */
package org.benchy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.benchy.BenchmarkResult;
import org.benchy.BenchmarkResultRepository;
import org.benchy.TestCaseResult;

public class FileBasedBenchmarkResultRepository
implements BenchmarkResultRepository {
    private File rootDir;

    private static void ensureExistingDirectory(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        if (!dir.isDirectory() && !dir.mkdirs()) {
            String msg = String.format("Unable to create directory %s", dir);
            throw new RuntimeException(msg);
        }
    }

    public FileBasedBenchmarkResultRepository() {
        this(System.getProperty("java.io.tmpdir"));
    }

    public FileBasedBenchmarkResultRepository(String rootDir) {
        this(new File(rootDir));
    }

    public FileBasedBenchmarkResultRepository(File rootDir) {
        FileBasedBenchmarkResultRepository.ensureExistingDirectory(rootDir);
        this.rootDir = rootDir;
    }

    @Override
    public BenchmarkResult loadLast(Date date, String benchmarkName) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public BenchmarkResult loadLast(String benchmark) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public BenchmarkResult load(Date date, String benchmarkName) {
        File resultsDir;
        if (date == null || benchmarkName == null) {
            throw new NullPointerException();
        }
        File benchmarkDirectory = this.getBenchmarkDirectory(benchmarkName);
        File todaysMeasurementsDir = new File(benchmarkDirectory, this.toDateSeperator(date));
        LinkedList<TestCaseResult> caseResults = new LinkedList<TestCaseResult>();
        if (todaysMeasurementsDir.isDirectory() && (resultsDir = this.findLastRun(todaysMeasurementsDir)).isDirectory()) {
            for (File file : resultsDir.listFiles(new ResultFileFilter())) {
                Properties properties = new Properties();
                try {
                    properties.load(new FileReader(file));
                    TestCaseResult caseResult = new TestCaseResult(properties);
                    caseResults.add(caseResult);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new BenchmarkResult(benchmarkName, caseResults);
    }

    @Override
    public void store(BenchmarkResult benchmarkResult) {
        if (benchmarkResult == null) {
            throw new NullPointerException();
        }
        File targetDir = this.createTargetDir(benchmarkResult.getBenchmarkName());
        int k = 1;
        for (TestCaseResult result : benchmarkResult.getTestCaseResultList()) {
            File outputFile = new File(targetDir, k + ".txt");
            this.writeOutputToFile(result, outputFile);
            ++k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutputToFile(TestCaseResult testCaseResult, File target) {
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(target));
            try {
                testCaseResult.getProperties().store(output, "");
            }
            finally {
                ((Writer)output).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private File createTargetDir(String benchmarkName) {
        File benchmarkDirectory = this.getBenchmarkDirectory(benchmarkName);
        File todaysMeasurementsDir = new File(benchmarkDirectory, this.toDateSeperator(new Date()));
        FileBasedBenchmarkResultRepository.ensureExistingDirectory(todaysMeasurementsDir);
        return this.createRunDir(todaysMeasurementsDir);
    }

    private File createRunDir(File todaysBenchmarksDir) {
        int max = 0;
        for (File file : todaysBenchmarksDir.listFiles()) {
            try {
                String name = file.getName();
                int value = Integer.parseInt(name);
                if (value <= max) continue;
                max = value;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        File runDir = new File(todaysBenchmarksDir, "" + (max + 1));
        FileBasedBenchmarkResultRepository.ensureExistingDirectory(runDir);
        return runDir;
    }

    private File findLastRun(File todaysBenchmarksDir) {
        int max = -1;
        File result = null;
        for (File file : todaysBenchmarksDir.listFiles()) {
            try {
                String name = file.getName();
                int value = Integer.parseInt(name);
                if (value <= max) continue;
                max = value;
                result = file;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return result;
    }

    private File getBenchmarkDirectory(String benchmarkName) {
        File result = this.rootDir;
        StringTokenizer tokenizer = new StringTokenizer(benchmarkName);
        while (tokenizer.hasMoreElements()) {
            result = new File(result, tokenizer.nextToken());
        }
        return result;
    }

    private String toDateSeperator(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("y-M-d");
        return format.format(date);
    }

    private static class ResultFileFilter
    implements FileFilter {
        private ResultFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".txt");
        }
    }
}

