/*
 * Decompiled with CFR 0.152.
 */
package org.benchy;

import java.util.Properties;
import org.benchy.executor.Benchmark;
import org.benchy.executor.TestCase;

public class TestCaseResult {
    private final Properties properties;

    public TestCaseResult(Benchmark benchmark, TestCase testCase, int attempt) {
        if (benchmark == null || testCase == null) {
            throw new NullPointerException();
        }
        if (attempt < 1) {
            throw new IllegalArgumentException();
        }
        this.properties = new Properties();
        this.copyPropertiesFromTestCase(testCase);
        this.copyPropertiesFromBenchmark(benchmark);
        this.put("attempt", attempt);
    }

    public TestCaseResult(Properties properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties = properties;
    }

    private void copyPropertiesFromTestCase(TestCase testCase) {
        Properties testCaseProps = testCase.getProperties();
        for (String name : testCaseProps.stringPropertyNames()) {
            String value = testCaseProps.getProperty(name);
            this.properties.put(name, value);
        }
    }

    private void copyPropertiesFromBenchmark(Benchmark benchmark) {
        this.put("benchmarkName", benchmark.benchmarkName);
        this.put("driverClass", benchmark.driverClass);
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void put(String key, Object value) {
        this.properties.put(key, value.toString());
    }

    private String getExistingProperty(String name) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException("property with name " + name + " is not found");
        }
        return value;
    }

    public int getIntProperty(String name) {
        String value = this.getExistingProperty(name);
        return Integer.parseInt(value);
    }

    public long getLongProperty(String name) {
        String value = this.getExistingProperty(name);
        return Long.parseLong(value);
    }

    public String getBenchmarkName() {
        return this.getExistingProperty("benchmarkName");
    }

    public int getAttempt() {
        return this.getIntProperty("attempt");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.properties.toString();
    }
}

