/*
 * Decompiled with CFR 0.152.
 */
package org.benchy.executor;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.benchy.BenchmarkResult;
import org.benchy.BenchmarkResultRepository;
import org.benchy.InMemoryBenchmarkRepository;
import org.benchy.TestCaseResult;
import org.benchy.executor.Benchmark;
import org.benchy.executor.BenchmarkDriver;
import org.benchy.executor.TestCase;

public class BenchmarkExecutor {
    private BenchmarkResultRepository resultRepository;

    public BenchmarkExecutor() {
        this(new InMemoryBenchmarkRepository());
    }

    public BenchmarkExecutor(BenchmarkResultRepository resultRepository) {
        if (resultRepository == null) {
            throw new NullPointerException();
        }
        this.resultRepository = resultRepository;
    }

    public void execute(List<Benchmark> benchmarkList) {
        this.execute(benchmarkList.toArray(new Benchmark[0]));
    }

    public void execute(Benchmark ... benchmarks) {
        for (Benchmark benchmark : benchmarks) {
            this.doExecute(benchmark);
        }
    }

    private void doExecute(Benchmark benchmark) {
        LinkedList<TestCaseResult> resultList = new LinkedList<TestCaseResult>();
        this.printLine();
        System.out.println("Starting benchmark: " + benchmark.benchmarkName);
        this.printLine();
        long beginNs = System.nanoTime();
        for (TestCase testCase : benchmark.testCases) {
            this.executeTestCase(benchmark, resultList, testCase);
        }
        long endNs = System.nanoTime();
        long durationMs = TimeUnit.NANOSECONDS.toMillis(endNs - beginNs);
        BenchmarkResult benchmarkResult = new BenchmarkResult(benchmark.benchmarkName, resultList);
        this.resultRepository.store(benchmarkResult);
        this.printLine();
        System.out.printf("Finished benchmark: %s in %s ms, result of %s testcases stored\n", benchmark.benchmarkName, durationMs, benchmarkResult.getTestCaseResultList().size());
        this.printLine();
    }

    private void executeTestCase(Benchmark benchmark, List<TestCaseResult> resultList, TestCase testCase) {
        this.warmup(benchmark, testCase);
        for (int attempt = 1; attempt <= testCase.getRunCount(); ++attempt) {
            TestCaseResult testCaseResult = this.run(benchmark, testCase, attempt);
            resultList.add(testCaseResult);
        }
    }

    private void printLine() {
        System.out.println("----------------------------------------------------------------------");
    }

    private TestCaseResult run(Benchmark benchmark, TestCase testCase, int attempt) {
        BenchmarkDriver driver = benchmark.loadDriver();
        driver.preRun(testCase);
        TestCaseResult caseResult = new TestCaseResult(benchmark, testCase, attempt);
        System.out.printf("Starting executing attempt %s testcase: %s\n", attempt, benchmark.benchmarkName + " " + testCase.getPropertiesDescription());
        long startMs = System.currentTimeMillis();
        long startNs = System.nanoTime();
        driver.run();
        long endNs = System.nanoTime();
        long endMs = System.currentTimeMillis();
        long durationNs = endNs - startNs;
        caseResult.put("duration(ns)", durationNs);
        caseResult.put("start(ms)", startMs);
        caseResult.put("end(ms)", endMs);
        driver.postRun(caseResult);
        System.out.printf("Finished executing attempt %s of testcase: %s in %s ms\n", attempt, caseResult, TimeUnit.NANOSECONDS.toMillis(durationNs));
        return caseResult;
    }

    private void warmup(Benchmark benchmark, TestCase testCase) {
        int warmupCount = testCase.getWarmupRunCount();
        System.out.printf("Starting %s warmup runs for testcase: %s\n", warmupCount, benchmark.benchmarkName + " " + testCase.getPropertiesDescription());
        for (int k = 0; k < testCase.getWarmupRunCount(); ++k) {
            this.run(benchmark, testCase, k + 1);
        }
        System.out.printf("Finished %s warmup runs for testcase: %s\n", warmupCount, benchmark.benchmarkName + " " + testCase.getPropertiesDescription());
    }
}

