/*
 * Decompiled with CFR 0.152.
 */
package org.benchy.executor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Map;
import org.benchy.BenchmarkResultRepository;
import org.benchy.FileBasedBenchmarkResultRepository;
import org.benchy.executor.Benchmark;
import org.benchy.executor.BenchmarkExecutor;
import org.benchy.executor.TestCase;

public class BenchmarkMain {
    public static void main(String[] args) throws Exception {
        System.out.println("Starting Benchy the Benchmark Executor");
        BenchmarkResultRepository repository = BenchmarkMain.loadRepository(args[0]);
        Benchmark benchmark = BenchmarkMain.loadBenchmark(BenchmarkMain.readbenchmarkJson());
        BenchmarkExecutor executor = new BenchmarkExecutor(repository);
        executor.execute(benchmark);
        System.out.println("Finished");
    }

    private static String readbenchmarkJson() throws IOException {
        String line;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        StringBuffer sb = new StringBuffer();
        while ((line = stdin.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    private static BenchmarkResultRepository loadRepository(String path) {
        File storedResultsRootDir = new File(path);
        return new FileBasedBenchmarkResultRepository(storedResultsRootDir);
    }

    private static Benchmark loadBenchmark(String benchmarkJson) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Benchmark.class, (Object)new BenchmarkDeserializer());
        builder.registerTypeAdapter(TestCase.class, (Object)new TestCaseDeserializer());
        Gson gson = builder.create();
        return (Benchmark)gson.fromJson(benchmarkJson, Benchmark.class);
    }

    static class TestCaseDeserializer
    implements JsonDeserializer {
        TestCaseDeserializer() {
        }

        public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject obj = (JsonObject)json;
            TestCase testCase = new TestCase();
            for (Map.Entry s : obj.entrySet()) {
                testCase.setProperty((String)s.getKey(), ((JsonElement)s.getValue()).getAsString());
            }
            return testCase;
        }
    }

    static class BenchmarkDeserializer
    implements JsonDeserializer {
        BenchmarkDeserializer() {
        }

        public Object deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            Benchmark benchmark = new Benchmark();
            JsonObject obj = (JsonObject)json;
            benchmark.benchmarkName = obj.get("benchmarkName").getAsString();
            benchmark.driverClass = obj.get("driverClass").getAsString();
            JsonArray testCaseJsonArray = obj.get("testcases").getAsJsonArray();
            for (JsonElement element : testCaseJsonArray) {
                JsonObject o = (JsonObject)element;
                TestCase testCase = (TestCase)context.deserialize((JsonElement)o, TestCase.class);
                benchmark.testCases.add(testCase);
            }
            return benchmark;
        }
    }
}

