/*
 * Decompiled with CFR 0.152.
 */
package org.benchy.graph;

import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.benchy.BenchmarkResult;
import org.benchy.BenchmarkResultRepository;
import org.benchy.FileBasedBenchmarkResultRepository;
import org.benchy.TestCaseResult;
import org.benchy.graph.GnuPlotGraphWriter;
import org.benchy.graph.GraphModel;

public class GraphMain {
    private BenchmarkResultRepository resultRepository;
    private GraphModel model = new GraphModel();

    public GraphMain(File benchmarkDir) {
        this.resultRepository = new FileBasedBenchmarkResultRepository(benchmarkDir);
    }

    public void doIt(File outputFile, List<String> names, String x, String y) {
        Date now = new Date();
        for (String name : names) {
            this.addToModel(now, name);
        }
        GnuPlotGraphWriter writer = new GnuPlotGraphWriter(outputFile, x, y);
        writer.write(this.model);
    }

    public void addToModel(Date date, String benchmarkName) {
        BenchmarkResult benchmarkResult = this.resultRepository.load(date, benchmarkName);
        for (TestCaseResult caseResult : benchmarkResult.getTestCaseResultList()) {
            this.model.add(benchmarkName, caseResult);
        }
    }

    public static void main(String[] args) {
        System.out.println("Diagram creator");
        File storageDirectory = new File(args[0]);
        File outputFile = new File(args[1]);
        List<String> names = GraphMain.getBenchmarks(args[2]);
        String x = args[3];
        String y = args[4];
        GraphMain graphMain = new GraphMain(storageDirectory);
        graphMain.doIt(outputFile, names, x, y);
        System.out.println("Exiting Diagram Creator");
    }

    private static List<String> getBenchmarks(String s) {
        LinkedList<String> benchmarks = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, ";");
        while (tokenizer.hasMoreTokens()) {
            benchmarks.add(tokenizer.nextToken());
        }
        return benchmarks;
    }
}

