/*
 * Decompiled with CFR 0.152.
 */
package org.benchy.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.benchy.TestCaseResult;
import org.benchy.graph.GraphModel;
import org.benchy.graph.GraphWriter;

public class GnuPlotGraphWriter
implements GraphWriter {
    private File outputFile;
    private String keyName;
    private String valueName;

    public GnuPlotGraphWriter(File outputFile, String keyName, String valueName) {
        this.outputFile = outputFile;
        this.keyName = keyName;
        this.valueName = valueName;
    }

    @Override
    public void write(GraphModel graphModel) {
        TreeMap<Integer, LinkedList<Pair>> treeMap = new TreeMap<Integer, LinkedList<Pair>>();
        for (String lineId : graphModel.getLineIds()) {
            List<TestCaseResult> propertyList = graphModel.get(lineId);
            for (TestCaseResult properies : propertyList) {
                String x = properies.get(this.keyName);
                String y = properies.get(this.valueName);
                LinkedList<Pair> valueList = (LinkedList<Pair>)treeMap.get(new Integer(x));
                if (valueList == null) {
                    valueList = new LinkedList<Pair>();
                    treeMap.put(new Integer(x), valueList);
                }
                valueList.add(new Pair(lineId, y));
            }
        }
        StringBuffer sb = new StringBuffer();
        for (Integer x : treeMap.descendingKeySet()) {
            sb.append(x);
            for (String lineId : graphModel.getLineIds()) {
                String result = "";
                for (Pair pair : (List)treeMap.get(x)) {
                    if (!pair.getLineId().equals(lineId)) continue;
                    result = pair.getValue();
                }
                sb.append(" " + result);
            }
            sb.append("\n");
        }
        this.write(sb.toString());
    }

    private void write(String s) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.outputFile));
            out.write(s);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Pair {
        private final String lineId;
        private final String value;

        public Pair(String lineId, String value) {
            this.lineId = lineId;
            this.value = value;
        }

        public String getLineId() {
            return this.lineId;
        }

        public String getValue() {
            return this.value;
        }
    }
}

