/*
 * Decompiled with CFR 0.152.
 */
package org.benchy;

import java.util.HashMap;
import java.util.Properties;

public class TestCase {
    private final Properties properties = new Properties();

    public TestCase() {
        this.setProperty("runCount", 1);
        this.setProperty("warmupRunCount", 1);
    }

    public int getRunCount() {
        return this.getIntProperty("runCount");
    }

    public void setRunCount(int runCount) {
        this.setProperty("runCount", runCount);
    }

    public int getWarmupRunCount() {
        return this.getIntProperty("warmupRunCount");
    }

    public void setWarmupRunCount(int warmupRunCount) {
        this.setProperty("warmupRunCount", warmupRunCount);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value.toString());
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public String getProperty(String name, String defaultValue) {
        String result = (String)this.properties.get(name);
        return result == null ? defaultValue : name;
    }

    public String getPropertiesDescription() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : this.properties.stringPropertyNames()) {
            map.put(name, this.properties.getProperty(name));
        }
        return ((Object)map).toString();
    }

    public int getIntProperty(String name) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException("property with name " + name + " is not found");
        }
        return Integer.parseInt(value);
    }

    public int getIntProperty(String name, int defaultValue) {
        String value = this.properties.getProperty(name, "" + defaultValue);
        return Integer.parseInt(value);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = this.properties.getProperty(name, "" + defaultValue);
        return Boolean.parseBoolean(value);
    }

    public long getLongProperty(String name, long defaultValue) {
        String value = this.properties.getProperty(name, "" + defaultValue);
        return Long.parseLong(value);
    }

    public long getLongProperty(String name) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException("property with name " + name + " is not found");
        }
        return Long.parseLong(value);
    }

    public boolean getBooleanProperty(String name) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException("property with name " + name + " is not found");
        }
        return Boolean.parseBoolean(value);
    }
}

