/*
 * Decompiled with CFR 0.152.
 */
package org.benchy.executor;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.benchy.Benchmark;
import org.benchy.BenchmarkDriver;
import org.benchy.BenchmarkResult;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.benchy.executor.BenchmarkExecutor;
import org.benchy.repository.BenchmarkResultRepository;

public class DefaultBenchmarkExecutor
implements BenchmarkExecutor {
    private final BenchmarkResultRepository resultRepository;

    public DefaultBenchmarkExecutor(BenchmarkResultRepository resultRepository) {
        if (resultRepository == null) {
            throw new NullPointerException();
        }
        this.resultRepository = resultRepository;
    }

    @Override
    public void execute(Benchmark ... benchmarks) {
        for (Benchmark benchmark : benchmarks) {
            this.doExecute(benchmark);
        }
    }

    private void doExecute(Benchmark benchmark) {
        if (benchmark == null) {
            throw new NullPointerException();
        }
        LinkedList<TestCaseResult> resultList = new LinkedList<TestCaseResult>();
        this.printLine();
        System.out.printf("Starting benchmark %s\n", benchmark.getBenchmarkName());
        this.printLine();
        long beginNs = System.nanoTime();
        for (TestCase testCase : benchmark.getTestCases()) {
            this.executeTestCase(benchmark, resultList, testCase);
        }
        long endNs = System.nanoTime();
        long durationMs = TimeUnit.NANOSECONDS.toMillis(endNs - beginNs);
        BenchmarkResult benchmarkResult = new BenchmarkResult(benchmark.getBenchmarkName(), resultList);
        this.resultRepository.store(benchmarkResult);
        this.printLine();
        System.out.printf("Finished benchmark: %s in %s ms, result of %s testcases stored\n", benchmark.getBenchmarkName(), durationMs, benchmarkResult.getTestCaseResults().size());
        this.printLine();
    }

    private void executeTestCase(Benchmark benchmark, List<TestCaseResult> resultList, TestCase testCase) {
        this.warmup(benchmark, testCase);
        for (int attempt = 1; attempt <= testCase.getRunCount(); ++attempt) {
            TestCaseResult testCaseResult = this.run(benchmark, testCase, attempt);
            resultList.add(testCaseResult);
        }
    }

    private void printLine() {
        System.out.println("----------------------------------------------------------------------");
    }

    private TestCaseResult run(Benchmark benchmark, TestCase testCase, int attempt) {
        BenchmarkDriver driver = benchmark.loadDriver();
        driver.preRun(testCase);
        TestCaseResult caseResult = new TestCaseResult(benchmark, testCase, attempt);
        System.out.printf("Starting executing attempt %s testcase: %s\n", attempt, benchmark.getBenchmarkName() + " " + testCase.getPropertiesDescription());
        long startMs = System.currentTimeMillis();
        long startNs = System.nanoTime();
        driver.run();
        long endNs = System.nanoTime();
        long endMs = System.currentTimeMillis();
        long durationNs = endNs - startNs;
        caseResult.put("duration(ns)", durationNs);
        caseResult.put("start(ms)", startMs);
        caseResult.put("end(ms)", endMs);
        driver.postRun(caseResult);
        System.out.printf("Finished executing attempt %s of testcase: %s in %s ms\n", attempt, caseResult, TimeUnit.NANOSECONDS.toMillis(durationNs));
        return caseResult;
    }

    private void warmup(Benchmark benchmark, TestCase testCase) {
        int warmupCount = testCase.getWarmupRunCount();
        System.out.printf("Starting %s warmup runs for testcase: %s\n", warmupCount, benchmark.getBenchmarkName() + " " + testCase.getPropertiesDescription());
        for (int k = 0; k < testCase.getWarmupRunCount(); ++k) {
            this.run(benchmark, testCase, k + 1);
        }
        System.out.printf("Finished %s warmup runs for testcase: %s\n", warmupCount, benchmark.getBenchmarkName() + " " + testCase.getPropertiesDescription());
    }
}

