/*
 * Decompiled with CFR 0.152.
 */
package org.benchy.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Map;
import org.benchy.Benchmark;
import org.benchy.TestCase;
import org.benchy.repackaged.com.google.gson.Gson;
import org.benchy.repackaged.com.google.gson.GsonBuilder;
import org.benchy.repackaged.com.google.gson.JsonArray;
import org.benchy.repackaged.com.google.gson.JsonDeserializationContext;
import org.benchy.repackaged.com.google.gson.JsonDeserializer;
import org.benchy.repackaged.com.google.gson.JsonElement;
import org.benchy.repackaged.com.google.gson.JsonObject;
import org.benchy.repackaged.com.google.gson.JsonParseException;
import org.benchy.repository.BenchmarkResultRepository;
import org.benchy.repository.FileBasedBenchmarkResultRepository;
import org.benchy.runner.DefaultBenchmarkRunner;
import org.benchy.runner.RunnerArguments;

public class Runner {
    public static void main(String[] args) throws Exception {
        System.out.println("Benchy: Starting the benchmark runner");
        RunnerArguments arguments = Runner.createArguments(args);
        BenchmarkResultRepository repository = Runner.loadRepository(arguments.repository);
        Benchmark benchmark = Runner.loadBenchmark(Runner.readbenchmarkJson());
        DefaultBenchmarkRunner runner = new DefaultBenchmarkRunner(repository);
        runner.execute(benchmark);
        System.out.println("Benchy: Finished");
    }

    private static RunnerArguments createArguments(String[] args) {
        RunnerArguments cli = new RunnerArguments();
        return cli;
    }

    private static String readbenchmarkJson() throws IOException {
        String line;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        StringBuffer sb = new StringBuffer();
        while ((line = stdin.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    private static BenchmarkResultRepository loadRepository(String path) {
        File storedResultsRootDir = new File(path);
        System.out.printf("Benchy: Storing benchmark result in '%s'\n", path);
        return new FileBasedBenchmarkResultRepository(storedResultsRootDir);
    }

    private static Benchmark loadBenchmark(String benchmarkJson) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Benchmark.class, (Object)new BenchmarkDeserializer());
        builder.registerTypeAdapter(TestCase.class, (Object)new TestCaseDeserializer());
        Gson gson = builder.create();
        return (Benchmark)gson.fromJson(benchmarkJson, Benchmark.class);
    }

    static class TestCaseDeserializer
    implements JsonDeserializer {
        TestCaseDeserializer() {
        }

        public Object deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = (JsonObject)json;
            TestCase testCase = new TestCase();
            for (Map.Entry s : obj.entrySet()) {
                testCase.setProperty((String)s.getKey(), ((JsonElement)s.getValue()).getAsString());
            }
            return testCase;
        }
    }

    static class BenchmarkDeserializer
    implements JsonDeserializer {
        BenchmarkDeserializer() {
        }

        public Object deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            Benchmark benchmark = new Benchmark();
            JsonObject obj = (JsonObject)json;
            benchmark.setBenchmarkName(obj.get("benchmarkName").getAsString());
            benchmark.setDriverClass(obj.get("driverClass").getAsString());
            JsonArray testCaseJsonArray = obj.get("testcases").getAsJsonArray();
            for (JsonElement element : testCaseJsonArray) {
                JsonObject o = (JsonObject)element;
                TestCase testCase = (TestCase)context.deserialize((JsonElement)o, TestCase.class);
                benchmark.getTestCases().add(testCase);
            }
            return benchmark;
        }
    }
}

