/*
 * Decompiled with CFR 0.152.
 */
package org.benchy.runner;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.benchy.Benchmark;
import org.benchy.BenchmarkDriver;
import org.benchy.BenchmarkResult;
import org.benchy.DriverParameter;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.benchy.repository.BenchmarkResultRepository;
import org.benchy.runner.BenchmarkRunner;

public class DefaultBenchmarkRunner
implements BenchmarkRunner {
    private final BenchmarkResultRepository resultRepository;

    public DefaultBenchmarkRunner(BenchmarkResultRepository resultRepository) {
        if (resultRepository == null) {
            throw new NullPointerException();
        }
        this.resultRepository = resultRepository;
    }

    @Override
    public void execute(Benchmark ... benchmarks) {
        for (Benchmark benchmark : benchmarks) {
            this.doExecute(benchmark);
        }
    }

    private void doExecute(Benchmark benchmark) {
        if (benchmark == null) {
            throw new NullPointerException();
        }
        LinkedList<TestCaseResult> resultList = new LinkedList<TestCaseResult>();
        this.printLine();
        System.out.printf("Starting benchmark %s\n", benchmark.getBenchmarkName());
        this.printLine();
        long beginNs = System.nanoTime();
        for (TestCase testCase : benchmark.getTestCases()) {
            this.executeTestCase(benchmark, resultList, testCase);
        }
        long endNs = System.nanoTime();
        long durationMs = TimeUnit.NANOSECONDS.toMillis(endNs - beginNs);
        BenchmarkResult benchmarkResult = new BenchmarkResult(benchmark.getBenchmarkName(), resultList);
        this.resultRepository.store(benchmarkResult);
        this.printLine();
        System.out.printf("Finished benchmark: %s in %s ms, result of %s testcases stored\n", benchmark.getBenchmarkName(), durationMs, benchmarkResult.getTestCaseResults().size());
        this.printLine();
    }

    private void executeTestCase(Benchmark benchmark, List<TestCaseResult> resultList, TestCase testCase) {
        this.warmup(benchmark, testCase);
        for (int attempt = 1; attempt <= testCase.getRunCount(); ++attempt) {
            TestCaseResult testCaseResult = this.run(benchmark, testCase, attempt);
            resultList.add(testCaseResult);
        }
    }

    private void printLine() {
        System.out.println("----------------------------------------------------------------------");
    }

    private TestCaseResult run(Benchmark benchmark, TestCase testCase, int attempt) {
        BenchmarkDriver driver = this.setupDriver(benchmark, testCase);
        TestCaseResult caseResult = new TestCaseResult(benchmark, testCase, attempt);
        this.printLine();
        System.out.printf("Starting attempt %s testcase: %s\n", attempt, benchmark.getBenchmarkName());
        this.printProperties(testCase.getProperties());
        this.printLine();
        long startMs = System.currentTimeMillis();
        long startNs = System.nanoTime();
        driver.run();
        long endNs = System.nanoTime();
        long endMs = System.currentTimeMillis();
        long durationNs = endNs - startNs;
        caseResult.put("duration(ns)", durationNs);
        caseResult.put("start(ms)", startMs);
        caseResult.put("end(ms)", endMs);
        driver.postRun(caseResult);
        this.printLine();
        System.out.printf("Finished attempt %s  in %s ms\n", attempt, TimeUnit.NANOSECONDS.toMillis(durationNs));
        this.printProperties(caseResult.getProperties());
        this.printLine();
        return caseResult;
    }

    private void printProperties(Properties properties) {
        for (Object key : properties.keySet()) {
            System.out.printf("\t%s = %s\n", key, properties.getProperty((String)key));
        }
    }

    private BenchmarkDriver setupDriver(Benchmark benchmark, TestCase testCase) {
        BenchmarkDriver driver = benchmark.loadDriver();
        for (Field field : driver.getClass().getDeclaredFields()) {
            if (!this.hasParameter(field)) continue;
            String value = testCase.getProperty(field.getName());
            if (value == null) {
                String msg = String.format("field %s on driver %s has no value in the testcase", field.getName(), driver.getClass().getName());
                throw new RuntimeException(msg);
            }
            field.setAccessible(true);
            Class<?> type = field.getType();
            try {
                if (type.equals(Short.TYPE)) {
                    field.setShort(driver, Short.parseShort(value));
                    continue;
                }
                if (type.equals(Byte.TYPE)) {
                    field.setByte(driver, Byte.parseByte(value));
                    continue;
                }
                if (type.equals(Integer.TYPE)) {
                    field.setInt(driver, Integer.parseInt(value));
                    continue;
                }
                if (type.equals(Long.TYPE)) {
                    field.setLong(driver, Long.parseLong(value));
                    continue;
                }
                if (type.equals(Boolean.TYPE)) {
                    field.setBoolean(driver, Boolean.parseBoolean(value));
                    continue;
                }
                if (type.equals(Float.TYPE)) {
                    field.setFloat(driver, Float.parseFloat(value));
                    continue;
                }
                if (type.equals(Double.TYPE)) {
                    field.setDouble(driver, Double.parseDouble(value));
                    continue;
                }
                if (!type.equals(String.class)) continue;
                field.set(driver, value);
            }
            catch (Exception e) {
                String msg = String.format("failed to set field %s on driver %s with value '%s'", field.getName(), driver.getClass().getName(), value);
                throw new RuntimeException(msg, e);
            }
        }
        driver.preRun(testCase);
        return driver;
    }

    private boolean hasParameter(Field field) {
        return field.getAnnotation(DriverParameter.class) != null;
    }

    private void warmup(Benchmark benchmark, TestCase testCase) {
        int warmupCount = testCase.getWarmupRunCount();
        this.printLine();
        System.out.printf("Starting %s warmup runs for testcase: %s\n", warmupCount, benchmark.getBenchmarkName());
        this.printLine();
        for (int k = 0; k < testCase.getWarmupRunCount(); ++k) {
            this.run(benchmark, testCase, k + 1);
        }
        this.printLine();
        System.out.printf("Finished %s warmup runs for testcase: %s\n", warmupCount, benchmark.getBenchmarkName());
        this.printProperties(testCase.getProperties());
        this.printLine();
    }
}

