/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.functions;

import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;

public class Functions {
    private static final IntFunction incOneIntFunction = new IncIntFunction(1);
    private static final LongFunction incOneLongFunction = new IncLongFunction(1L);
    private static final IntFunction decOneIntFunction = new IncIntFunction(-1);
    private static final LongFunction decOneLongFunction = new IncLongFunction(-1L);
    private static final IntFunction identityIntFunction = new IntFunction(){

        @Override
        public int call(int current) {
            return current;
        }

        public String toString() {
            return "IdentityIntFunction";
        }
    };
    private static final LongFunction identityLongFunction = new LongFunction(){

        @Override
        public long call(long current) {
            return current;
        }

        public String toString() {
            return "IdentityLongFunction";
        }
    };

    public static IntFunction newIdentityIntFunction() {
        return identityIntFunction;
    }

    public static LongFunction newIdentityLongFunction() {
        return identityLongFunction;
    }

    public static IntFunction newIncIntFunction() {
        return incOneIntFunction;
    }

    public static IntFunction newDecIntFunction() {
        return decOneIntFunction;
    }

    public static LongFunction newIncLongFunction() {
        return incOneLongFunction;
    }

    public static LongFunction newDecLongFunction() {
        return decOneLongFunction;
    }

    public static IntFunction newIncIntFunction(int amount) {
        switch (amount) {
            case 0: {
                return identityIntFunction;
            }
            case 1: {
                return incOneIntFunction;
            }
            case -1: {
                return decOneIntFunction;
            }
        }
        return new IncIntFunction(amount);
    }

    public static LongFunction newIncLongFunction(long amount) {
        if (amount == 0L) {
            return identityLongFunction;
        }
        if (amount == 1L) {
            return incOneLongFunction;
        }
        if (amount == -1L) {
            return decOneLongFunction;
        }
        return new IncLongFunction(amount);
    }

    private Functions() {
    }

    private static class IncLongFunction
    extends LongFunction {
        private final long value;

        public IncLongFunction(long value) {
            this.value = value;
        }

        @Override
        public long call(long current) {
            return current + this.value;
        }

        public String toString() {
            return "IncLongFunction{value=" + this.value + '}';
        }
    }

    private static class IncIntFunction
    extends IntFunction {
        private final int value;

        public IncIntFunction(int value) {
            this.value = value;
        }

        @Override
        public int call(int current) {
            return current + this.value;
        }

        public String toString() {
            return "IncIntFunction{value=" + this.value + '}';
        }
    }
}

