/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.orec;

import org.multiverse.api.exceptions.PanicError;
import org.multiverse.stms.beta.conflictcounters.GlobalConflictCounter;
import org.multiverse.stms.beta.orec.Orec;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.utils.ToolUnsafe;
import sun.misc.Unsafe;

public class FastOrec
implements Orec {
    private static final int READBIASED_THRESHOLD = 16;
    private static final long BITMASK_COMMITLOCK = Long.MIN_VALUE;
    private static final long BITMASK_UPDATELOCK = 0x4000000000000000L;
    private static final long BITMASK_READBIASED = 0x2000000000000000L;
    private static final long BITMASK_SURPLUS = 2305843009213693440L;
    private static final long BITMASK_READONLY_COUNT = 1023L;
    protected static final Unsafe ___unsafe = ToolUnsafe.getUnsafe();
    protected static final long valueOffset;
    private volatile long ___orecValue;

    @Override
    public boolean ___hasLock() {
        long current = this.___orecValue;
        return FastOrec.hasUpdateLock(current) || FastOrec.hasCommitLock(this.___orecValue);
    }

    @Override
    public boolean ___hasUpdateLock() {
        return FastOrec.hasUpdateLock(this.___orecValue);
    }

    @Override
    public final boolean ___hasCommitLock() {
        return FastOrec.hasCommitLock(this.___orecValue);
    }

    @Override
    public final int ___getReadBiasedThreshold() {
        return 16;
    }

    @Override
    public final long ___getSurplus() {
        return FastOrec.getSurplus(this.___orecValue);
    }

    @Override
    public final boolean ___isReadBiased() {
        return FastOrec.isReadBiased(this.___orecValue);
    }

    @Override
    public final int ___getReadonlyCount() {
        return FastOrec.getReadonlyCount(this.___orecValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final int ___arrive(int spinCount) {
        do {
            long current;
            if (FastOrec.hasCommitLock(current = this.___orecValue)) {
                this.yieldIfNeeded(--spinCount);
                continue;
            }
            long surplus = FastOrec.getSurplus(current);
            boolean isReadBiased = FastOrec.isReadBiased(current);
            if (isReadBiased) {
                if (surplus != 0L) {
                    if (surplus != 1L) throw new PanicError("Surplus for a readbiased orec can never be larger than 1");
                    return 1;
                }
                surplus = 1L;
            } else {
                ++surplus;
            }
            long next = FastOrec.setSurplus(current, surplus);
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            if (!isReadBiased) return 0;
            return 1;
        } while (spinCount >= 0);
        return 2;
    }

    private void yieldIfNeeded(int remainingSpins) {
        if (remainingSpins % ___SpinYield == 0 && remainingSpins > 0) {
            Thread.yield();
        }
    }

    @Override
    public final int ___tryLockAndArrive(int spinCount, boolean commitLock) {
        do {
            long current;
            if (FastOrec.hasLock(current = this.___orecValue)) {
                this.yieldIfNeeded(--spinCount);
                continue;
            }
            long surplus = FastOrec.getSurplus(current);
            boolean isReadBiased = FastOrec.isReadBiased(current);
            if (isReadBiased) {
                if (surplus == 0L) {
                    surplus = 1L;
                } else if (surplus > 1L) {
                    throw new PanicError("Can't arriveAndLockForUpdate; surplus is larger than 2: " + FastOrec.___toOrecString(current));
                }
            } else {
                ++surplus;
            }
            long next = FastOrec.setSurplus(current, surplus);
            next = commitLock ? FastOrec.setCommitLock(next, true) : FastOrec.setUpdateLock(next, true);
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            return isReadBiased ? 1 : 0;
        } while (spinCount >= 0);
        return 2;
    }

    @Override
    public final boolean ___tryLockAfterNormalArrive(int spinCount, boolean commitLock) {
        do {
            long current;
            if (FastOrec.hasLock(current = this.___orecValue)) {
                this.yieldIfNeeded(--spinCount);
                continue;
            }
            if (FastOrec.getSurplus(current) == 0L) {
                throw new PanicError("Can't acquire the updatelock is there is no surplus (so if it didn't do a read before)" + FastOrec.___toOrecString(current));
            }
            long next = current;
            next = commitLock ? FastOrec.setCommitLock(next, true) : FastOrec.setUpdateLock(current, true);
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            return true;
        } while (spinCount >= 0);
        return false;
    }

    @Override
    public void ___upgradeToCommitLock() {
        long next;
        long current;
        do {
            if (FastOrec.hasCommitLock(current = this.___orecValue)) {
                return;
            }
            if (!FastOrec.hasUpdateLock(current)) {
                throw new PanicError("Can't upgradeToCommitLock is the updateLock is not acquired");
            }
            next = FastOrec.setCommitLock(current, true);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = FastOrec.setUpdateLock(next, false)));
    }

    @Override
    public final void ___departAfterReading() {
        long surplus;
        long next;
        long current;
        do {
            boolean hasCommitLock;
            if ((surplus = FastOrec.getSurplus(current = this.___orecValue)) == 0L) {
                throw new PanicError("Can't depart if there is no surplus " + FastOrec.___toOrecString(current));
            }
            boolean isReadBiased = FastOrec.isReadBiased(current);
            if (isReadBiased) {
                throw new PanicError("Can't depart from a readbiased orec " + FastOrec.___toOrecString(current));
            }
            int readonlyCount = FastOrec.getReadonlyCount(current);
            if (readonlyCount < 16) {
                ++readonlyCount;
            }
            if (!(hasCommitLock = FastOrec.hasCommitLock(current)) && --surplus == 0L && readonlyCount == 16) {
                isReadBiased = true;
                readonlyCount = 0;
            }
            next = FastOrec.setIsReadBiased(current, isReadBiased);
            next = FastOrec.setReadonlyCount(next, readonlyCount);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = FastOrec.setSurplus(next, surplus)));
    }

    @Override
    public final void ___departAfterReadingAndUnlock() {
        long surplus;
        long next;
        long current;
        do {
            if ((surplus = FastOrec.getSurplus(current = this.___orecValue)) == 0L) {
                throw new PanicError("Can't ___departAfterReadingAndUnlock if there is no surplus: " + FastOrec.___toOrecString(current));
            }
            if (!FastOrec.hasLock(current)) {
                throw new PanicError("Can't ___departAfterReadingAndUnlock if the lock is not acquired " + FastOrec.___toOrecString(current));
            }
            boolean isReadBiased = FastOrec.isReadBiased(current);
            if (isReadBiased) {
                throw new PanicError("Can't ___departAfterReadingAndUnlock when readbiased orec " + FastOrec.___toOrecString(current));
            }
            int readonlyCount = FastOrec.getReadonlyCount(current);
            --surplus;
            if (readonlyCount < 16) {
                ++readonlyCount;
            }
            if (surplus == 0L && readonlyCount == 16) {
                isReadBiased = true;
                readonlyCount = 0;
            }
            next = FastOrec.setCommitLock(current, false);
            next = FastOrec.setUpdateLock(next, false);
            next = FastOrec.setIsReadBiased(next, isReadBiased);
            next = FastOrec.setReadonlyCount(next, readonlyCount);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = FastOrec.setSurplus(next, surplus)));
    }

    @Override
    public final long ___departAfterUpdateAndUnlock(GlobalConflictCounter globalConflictCounter, BetaTransactionalObject transactionalObject) {
        long surplus;
        long next;
        long current;
        boolean conflictSend = false;
        do {
            boolean conflict;
            if (!FastOrec.hasLock(current = this.___orecValue)) {
                throw new PanicError("Can't ___departAfterUpdateAndUnlock is the update/commit lock is not acquired " + FastOrec.___toOrecString(current));
            }
            surplus = FastOrec.getSurplus(current);
            if (surplus == 0L) {
                throw new PanicError("Can't ___departAfterUpdateAndUnlock is there is no surplus " + FastOrec.___toOrecString(current));
            }
            if (FastOrec.isReadBiased(current)) {
                if (surplus > 1L) {
                    throw new PanicError("The surplus can never be larger than 1 if readBiased " + FastOrec.___toOrecString(current));
                }
                conflict = true;
                surplus = 0L;
            } else {
                boolean bl = conflict = --surplus > 0L;
            }
            if (conflict && !conflictSend) {
                globalConflictCounter.signalConflict(transactionalObject);
                conflictSend = true;
            }
            if (surplus != 0L || !FastOrec.hasCommitLock(current)) continue;
            this.___orecValue = 0L;
            return surplus;
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = FastOrec.setSurplus(0L, surplus)));
        return surplus;
    }

    @Override
    public final long ___departAfterFailureAndUnlock() {
        long surplus;
        long next;
        long current;
        do {
            if (!FastOrec.hasLock(current = this.___orecValue)) {
                throw new PanicError("Can't ___departAfterFailureAndUnlock if the lock was not acquired " + FastOrec.___toOrecString(current));
            }
            surplus = FastOrec.getSurplus(current);
            if (surplus == 0L) {
                throw new PanicError("Can't ___departAfterFailureAndUnlock if there is no surplus " + FastOrec.___toOrecString(current));
            }
            if (FastOrec.isReadBiased(current)) {
                if (surplus > 1L) {
                    throw new PanicError("Can't ___departAfterFailureAndUnlock with a surplus larger than 1 if the orec is read biased " + FastOrec.___toOrecString(current));
                }
            } else {
                --surplus;
            }
            next = FastOrec.setCommitLock(current, false);
            next = FastOrec.setUpdateLock(next, false);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = FastOrec.setSurplus(next, surplus)));
        return surplus;
    }

    @Override
    public final void ___departAfterFailure() {
        long surplus;
        long next;
        long current;
        do {
            if (FastOrec.isReadBiased(current = this.___orecValue)) {
                throw new PanicError("Can't departAfterFailure when orec is readbiased:" + FastOrec.___toOrecString(current));
            }
            surplus = FastOrec.getSurplus(current);
            if (FastOrec.hasCommitLock(current)) {
                if (surplus >= 2L) continue;
                throw new PanicError("there must be at least 2 readers, the thread that acquired the lock, and the calling thread " + FastOrec.___toOrecString(current));
            }
            if (surplus != 0L) continue;
            throw new PanicError("Can't departAfterFailure if there is no surplus " + FastOrec.___toOrecString(current));
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = FastOrec.setSurplus(current, --surplus)));
    }

    @Override
    public final void ___unlockByReadBiased() {
        long next;
        long current;
        do {
            if (!FastOrec.isReadBiased(current = this.___orecValue)) {
                throw new PanicError("Can't ___unlockByReadBiased when it is not readbiased " + FastOrec.___toOrecString(current));
            }
            if (!FastOrec.hasLock(current)) {
                throw new PanicError("Can't ___unlockByReadBiased if it isn't locked " + FastOrec.___toOrecString(current));
            }
            if (FastOrec.getSurplus(current) > 1L) {
                throw new PanicError("Surplus for a readbiased orec never can be larger than 1 " + FastOrec.___toOrecString(current));
            }
            next = FastOrec.setCommitLock(current, false);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = FastOrec.setUpdateLock(next, false)));
    }

    @Override
    public final String ___toOrecString() {
        return FastOrec.___toOrecString(this.___orecValue);
    }

    public static long setCommitLock(long value, boolean commitLock) {
        return value & Long.MAX_VALUE | (commitLock ? 1L : 0L) << 63;
    }

    public static boolean hasLock(long value) {
        return (value & 0xC000000000000000L) != 0L;
    }

    public static boolean hasCommitLock(long value) {
        return (value & Long.MIN_VALUE) != 0L;
    }

    public static boolean isReadBiased(long value) {
        return (value & 0x2000000000000000L) != 0L;
    }

    public static long setIsReadBiased(long value, boolean isReadBiased) {
        return value & 0xDFFFFFFFFFFFFFFFL | (isReadBiased ? 1L : 0L) << 61;
    }

    public static boolean hasUpdateLock(long value) {
        return (value & 0x4000000000000000L) != 0L;
    }

    public static long setUpdateLock(long value, boolean updateLock) {
        return value & 0xBFFFFFFFFFFFFFFFL | (updateLock ? 1L : 0L) << 62;
    }

    public static int getReadonlyCount(long value) {
        return (int)(value & 0x3FFL);
    }

    public static long setReadonlyCount(long value, int readonlyCount) {
        return value & 0xFFFFFFFFFFFFFC00L | (long)readonlyCount;
    }

    public static long setSurplus(long value, long surplus) {
        return value & 0xE0000000000001FFL | surplus << 10;
    }

    public static long getSurplus(long value) {
        return (value & 0x1FFFFFFFFFFFFE00L) >> 10;
    }

    private static String ___toOrecString(long value) {
        return String.format("FastOrec(hasCommitLock=%s, hasUpdateLock=%s, surplus=%s, isReadBiased=%s, readonlyCount=%s)", FastOrec.hasCommitLock(value), FastOrec.hasUpdateLock(value), FastOrec.getSurplus(value), FastOrec.isReadBiased(value), FastOrec.getReadonlyCount(value));
    }

    static {
        try {
            valueOffset = ___unsafe.objectFieldOffset(FastOrec.class.getDeclaredField("___orecValue"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

