/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse;

import org.junit.Assert;

public abstract class TestThread
extends Thread {
    private volatile Throwable throwable;
    private volatile Boolean endedWithInterruptStatus;
    private final boolean startInterrupted;

    public TestThread() {
        this("TestThread");
    }

    public TestThread(String name) {
        this(name, false);
    }

    public TestThread(String name, boolean startInterrupted) {
        super(name);
        this.startInterrupted = startInterrupted;
    }

    public boolean doesStartInterrupted() {
        return this.startInterrupted;
    }

    public Boolean hasEndedWithInterruptStatus() {
        return this.endedWithInterruptStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (this.startInterrupted) {
            this.interrupt();
        }
        try {
            this.doRun();
        }
        catch (Throwable ex) {
            System.out.printf("Thread %s has thrown an exception\n", this.getName());
            ex.printStackTrace();
            this.throwable = ex;
        }
        finally {
            this.endedWithInterruptStatus = this.isInterrupted();
        }
    }

    public abstract void doRun() throws Exception;

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void assertNothingThrown() {
        Assert.assertNull((Object)this.throwable);
    }
}

