/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.junit.Assert;
import org.multiverse.TestThread;
import org.multiverse.ThreadLocalRandom;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionStatus;
import org.multiverse.utils.instrumentation.InstrumentationProblemMonitor;

public class TestUtils {
    public static void resetInstrumentationProblemMonitor() {
        try {
            Field field = InstrumentationProblemMonitor.class.getDeclaredField("problemFound");
            field.setAccessible(true);
            field.set(InstrumentationProblemMonitor.INSTANCE, false);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertIsInterrupted(Thread t) {
        Assert.assertTrue((boolean)t.isInterrupted());
    }

    public static void assertAreAlive(Thread ... threads) {
        for (Thread thread : threads) {
            Assert.assertTrue((boolean)thread.isAlive());
        }
    }

    public static void testIncomplete() {
        StackTraceElement caller = new Throwable().getStackTrace()[1];
        System.out.println("============================================================================");
        System.out.printf("Test '%s' incomplete in file '%s' at line %s\n", caller.getMethodName(), caller.getFileName(), caller.getLineNumber());
        System.out.println("============================================================================");
    }

    public static void testIncomplete(String reason) {
        StackTraceElement caller = new Throwable().getStackTrace()[1];
        System.out.println("============================================================================");
        System.out.printf("Test '%s' incomplete in file '%s' at line %s\n", caller.getMethodName(), caller.getFileName(), caller.getLineNumber());
        System.out.printf("Reason: %s\n", reason);
        System.out.println("============================================================================");
    }

    public static void assertNoInstrumentationProblems() {
        Assert.assertFalse((boolean)InstrumentationProblemMonitor.INSTANCE.isProblemFound());
    }

    public static void assertIsActive(Transaction t) {
        Assert.assertNotNull((String)"No transaction found", (Object)t);
        junit.framework.Assert.assertEquals((Object)TransactionStatus.active, (Object)t.getStatus());
    }

    public static void assertIsCommitted(Transaction t) {
        Assert.assertNotNull((String)"No transaction found", (Object)t);
        junit.framework.Assert.assertEquals((Object)TransactionStatus.committed, (Object)t.getStatus());
    }

    public static void assertIsAborted(Transaction t) {
        Assert.assertNotNull((String)"No transaction found", (Object)t);
        junit.framework.Assert.assertEquals((Object)TransactionStatus.aborted, (Object)t.getStatus());
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static boolean randomBoolean() {
        return TestUtils.randomInt(10) % 2 == 0;
    }

    public static int randomInt(int max) {
        return ThreadLocalRandom.current().nextInt(max);
    }

    public static void sleepRandomMs(int maxMs) {
        if (maxMs <= 0) {
            return;
        }
        TestUtils.sleepMs(TestUtils.randomInt(maxMs));
        Thread.yield();
    }

    public static void sleepMs(long ms) {
        if (ms == 0L) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new RuntimeException(ex);
        }
    }

    public static void startAll(TestThread ... threads) {
        for (TestThread thread : threads) {
            thread.start();
        }
    }

    public static void joinAll(TestThread ... threads) {
        TestUtils.joinAll(300000L, threads);
    }

    public static void joinAll(long maxJoinTimeMillis, TestThread ... threads) {
        if (maxJoinTimeMillis < 0L) {
            throw new IllegalArgumentException();
        }
        LinkedList<TestThread> uncompleted = new LinkedList<TestThread>(Arrays.asList(threads));
        long maxTimeMillis = System.currentTimeMillis() + maxJoinTimeMillis;
        while (!uncompleted.isEmpty()) {
            Iterator it = uncompleted.iterator();
            while (it.hasNext()) {
                TestThread thread = (TestThread)it.next();
                try {
                    if (System.currentTimeMillis() > maxTimeMillis) {
                        Assert.fail((String)String.format("Failed to join all threads in %s ms, remaining threads %s", maxJoinTimeMillis, uncompleted));
                    }
                    thread.join(100L);
                    if (thread.isAlive()) continue;
                    it.remove();
                    if (thread.getThrowable() == null) {
                        System.out.printf("%s completed successfully\n", thread.getName());
                        continue;
                    }
                    System.out.printf("%s encountered the following error\n", thread.getName());
                    thread.getThrowable().printStackTrace();
                    Assert.fail((String)String.format("%s completed with failure", thread.getName()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(String.format("Joining %s was interrupted", thread), e);
                }
            }
        }
    }

    public static String readText(File errorOutputFile) {
        try {
            String line;
            StringBuffer sb = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(errorOutputFile));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            return sb.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

