/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.ScheduleType;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoTransactionFoundException;
import org.multiverse.api.exceptions.RetryError;

public class StmUtilsTest {
    @Before
    public void setup() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void teardown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=RetryError.class)
    public void retryWithTransactionThrowsRetryError() {
        Transaction t = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        StmUtils.retry();
    }

    @Test(expected=NoTransactionFoundException.class)
    public void retryWithoutTransactionFails() {
        StmUtils.retry();
    }

    @Test
    public void deferredExecuteIsForwardedToTransactionThreadLocal() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        Transaction t = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        StmUtils.deferredExecute((Runnable)task);
        ((Transaction)Mockito.verify((Object)t)).schedule(task, ScheduleType.postCommit);
    }

    @Test(expected=NoTransactionFoundException.class)
    public void deferredExecuteWithoutTransactionFails() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        StmUtils.deferredExecute((Runnable)task);
    }

    @Test(expected=NoTransactionFoundException.class)
    public void compensatingExecuteWithoutTransactionFails() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        StmUtils.compensatingExecute((Runnable)task);
    }

    @Test
    public void compensatingExecuteIsForwardedToTransactionThreadLocal() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        Transaction t = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        StmUtils.compensatingExecute((Runnable)task);
        ((Transaction)Mockito.verify((Object)t)).schedule(task, ScheduleType.postAbort);
    }
}

