/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.utils.latches.CheapLatch;
import org.multiverse.utils.latches.Latch;

public class AbstractTransaction_abortAndRegisterRetryLatchTest {
    @Test
    public void nullLatchFails() {
        AbstractTransactionImpl transaction = new AbstractTransactionImpl();
        try {
            transaction.abortAndRegisterRetryLatch(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction)transaction);
    }

    @Test
    public void failsIfCommitted() {
        AbstractTransactionImpl transaction = new AbstractTransactionImpl();
        transaction.commit();
        CheapLatch latch = new CheapLatch();
        try {
            transaction.abortAndRegisterRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction)transaction);
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void failsIfAborted() {
        AbstractTransactionImpl transaction = new AbstractTransactionImpl();
        transaction.abort();
        CheapLatch latch = new CheapLatch();
        try {
            transaction.abortAndRegisterRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction)transaction);
        Assert.assertFalse((boolean)latch.isOpen());
    }
}

