/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.utils.clock.Clock;
import org.multiverse.utils.clock.StrictClock;

public class AbstractTransaction_abortAndReturnStartedTest {
    private StrictClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictClock(1L);
    }

    @Test
    public void startedTransaction() {
        AbstractTransactionImpl t = new AbstractTransactionImpl((Clock)this.clock);
        long version = this.clock.getTime();
        Transaction result = t.abortAndReturnRestarted();
        Assert.assertSame((Object)((Object)t), (Object)result);
        TestUtils.assertIsActive((Transaction)t);
        Assert.assertEquals((long)version, (long)this.clock.getTime());
    }

    @Test
    public void committedTransaction() {
        AbstractTransactionImpl t = new AbstractTransactionImpl((Clock)this.clock);
        t.commit();
        long version = this.clock.getTime();
        Transaction result = t.abortAndReturnRestarted();
        Assert.assertSame((Object)((Object)t), (Object)result);
        TestUtils.assertIsActive((Transaction)t);
        Assert.assertEquals((long)version, (long)this.clock.getTime());
    }

    @Test
    public void abortedTransaction() {
        AbstractTransactionImpl t = new AbstractTransactionImpl((Clock)this.clock);
        t.abort();
        long version = this.clock.getTime();
        Transaction result = t.abortAndReturnRestarted();
        Assert.assertSame((Object)((Object)t), (Object)result);
        TestUtils.assertIsActive((Transaction)t);
        Assert.assertEquals((long)version, (long)this.clock.getTime());
    }
}

