/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.utils.clock.StrictClock;

public class AbstractTransaction_abortTest {
    private StrictClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictClock(1L);
    }

    @Test
    public void abortStartedTransaction() {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        long startVersion = this.clock.getTime();
        t.abort();
        Assert.assertEquals((long)startVersion, (long)this.clock.getTime());
        TestUtils.assertIsAborted((Transaction)t);
    }

    @Test
    public void abortCommittedTransactionShouldFail() {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.commit();
        long startVersion = this.clock.getTime();
        try {
            t.abort();
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)startVersion, (long)this.clock.getTime());
        TestUtils.assertIsCommitted((Transaction)t);
    }

    @Test
    public void abortAbortedTransactionIsIgnored() {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.abort();
        long startVersion = this.clock.getTime();
        t.abort();
        Assert.assertEquals((long)startVersion, (long)this.clock.getTime());
        TestUtils.assertIsAborted((Transaction)t);
    }
}

