/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.CommitFailureException;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.AbstractTransaction;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.utils.clock.Clock;
import org.multiverse.utils.clock.StrictClock;

public class AbstractTransaction_commitTest {
    private StrictClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictClock(1L);
    }

    @Ignore
    @Test
    public void commitOnStartedTransactionIsDelegated() {
        AbstractTransaction t = (AbstractTransaction)Mockito.mock(AbstractTransaction.class);
        Mockito.when((Object)t.onCommit()).thenReturn((Object)10L);
        long version = t.commit();
        Assert.assertEquals((long)10L, (long)version);
        TestUtils.assertIsCommitted((Transaction)t);
    }

    @Ignore
    @Test
    public void commitOnStartedLeadsToAbortWhenExceptionIsThrow() {
        AbstractTransaction t = (AbstractTransaction)Mockito.mock(AbstractTransaction.class);
        Mockito.when((Object)t.onCommit()).thenThrow(new Throwable[]{new CommitFailureException()});
        try {
            t.commit();
            Assert.fail();
        }
        catch (CommitFailureException commitFailureException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction)t);
    }

    @Test
    public void commitOnCommittedTransactionIsIgnored() {
        AbstractTransactionImpl t = new AbstractTransactionImpl((Clock)this.clock);
        t.commit();
        long version = this.clock.getTime();
        t.commit();
        TestUtils.assertIsCommitted((Transaction)t);
        Assert.assertEquals((long)version, (long)this.clock.getTime());
    }

    @Test
    public void commitOnAbortedTransactionFails() {
        AbstractTransactionImpl t = new AbstractTransactionImpl((Clock)this.clock);
        t.abort();
        long version = this.clock.getTime();
        try {
            t.commit();
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction)t);
        Assert.assertEquals((long)version, (long)this.clock.getTime());
    }
}

