/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ScheduleType;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.AbstractTransactionImpl;

public class AbstractTransaction_scheduleTest {
    @Test
    public void scheduleFailsWithNullTask() {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        try {
            t.schedule(null, ScheduleType.postAbort);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction)t);
    }

    @Test
    public void scheduleFailsWithNullScheduleType() {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        TestTask testTask = new TestTask();
        try {
            t.schedule(testTask, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction)t);
        Assert.assertEquals((long)0L, (long)testTask.executionCount);
    }

    @Test
    public void preCommitTaskIsExecutedBeforeCommit() {
        TestTask task = new TestTask();
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.schedule(task, ScheduleType.preCommit);
        t.commit();
        TestUtils.assertIsCommitted((Transaction)t);
        Assert.assertEquals((long)1L, (long)task.executionCount);
    }

    @Test
    public void postCommitTaskIsExecutedAfterCommit() {
        TestTask task = new TestTask();
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.schedule(task, ScheduleType.postCommit);
        t.commit();
        TestUtils.assertIsCommitted((Transaction)t);
        Assert.assertEquals((long)1L, (long)task.executionCount);
    }

    @Test
    public void preAbortTaskIsExecutedBeforeAbort() {
        TestTask task = new TestTask();
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.schedule(task, ScheduleType.preAbort);
        t.abort();
        TestUtils.assertIsAborted((Transaction)t);
        Assert.assertEquals((long)1L, (long)task.executionCount);
    }

    @Test
    public void postAbortTaskIsExecutedAfterAbort() {
        TestTask task = new TestTask();
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.schedule(task, ScheduleType.postAbort);
        t.abort();
        TestUtils.assertIsAborted((Transaction)t);
        Assert.assertEquals((long)1L, (long)task.executionCount);
    }

    @Test
    public void abortTasksAreNotExecutedOnSuccessfulCommit() {
        TestTask task1 = new TestTask();
        TestTask task2 = new TestTask();
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.schedule(task1, ScheduleType.preAbort);
        t.schedule(task2, ScheduleType.postAbort);
        t.commit();
        Assert.assertEquals((long)0L, (long)task1.executionCount);
        Assert.assertEquals((long)0L, (long)task2.executionCount);
    }

    @Test
    public void commitTasksAreNotExecutedOnAbort() {
        TestTask task1 = new TestTask();
        TestTask task2 = new TestTask();
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.schedule(task1, ScheduleType.postCommit);
        t.schedule(task2, ScheduleType.preCommit);
        t.abort();
        Assert.assertEquals((long)0L, (long)task1.executionCount);
        Assert.assertEquals((long)0L, (long)task2.executionCount);
    }

    @Test
    public void failingPostCommitTaskDoesNotRollbackCommit() {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.schedule(new FailingTask(), ScheduleType.postCommit);
        try {
            t.commit();
            Assert.fail();
        }
        catch (FailException failException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction)t);
    }

    @Test
    public void scheduleTaskFailsOnCommittedTransaction() {
        this.scheduleTaskFailsOnCommittedTransaction(ScheduleType.postAbort);
        this.scheduleTaskFailsOnCommittedTransaction(ScheduleType.preAbort);
        this.scheduleTaskFailsOnCommittedTransaction(ScheduleType.postCommit);
        this.scheduleTaskFailsOnCommittedTransaction(ScheduleType.preCommit);
    }

    public void scheduleTaskFailsOnCommittedTransaction(ScheduleType scheduleType) {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.commit();
        TestTask task = new TestTask();
        try {
            t.schedule(task, scheduleType);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction)t);
        Assert.assertEquals((long)0L, (long)task.executionCount);
    }

    @Test
    public void scheduleTaskFailsOnAbortedTransaction() {
        this.scheduleTaskFailsOnAbortedTransaction(ScheduleType.postAbort);
        this.scheduleTaskFailsOnAbortedTransaction(ScheduleType.preAbort);
        this.scheduleTaskFailsOnAbortedTransaction(ScheduleType.postCommit);
        this.scheduleTaskFailsOnAbortedTransaction(ScheduleType.preCommit);
    }

    public void scheduleTaskFailsOnAbortedTransaction(ScheduleType scheduleType) {
        AbstractTransactionImpl t = new AbstractTransactionImpl();
        t.abort();
        TestTask task = new TestTask();
        try {
            t.schedule(task, scheduleType);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction)t);
        Assert.assertEquals((long)0L, (long)task.executionCount);
    }

    static class FailException
    extends RuntimeException {
        FailException() {
        }
    }

    static class FailingTask
    implements Runnable {
        FailingTask() {
        }

        @Override
        public void run() {
            throw new FailException();
        }
    }

    static class TestTask
    implements Runnable {
        int executionCount;

        TestTask() {
        }

        @Override
        public void run() {
            ++this.executionCount;
        }
    }
}

