/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.clock;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.utils.clock.Clock;
import org.multiverse.utils.clock.StrictClock;

public class StrictClockLongTest {
    private final long tickCount = 10000000L;
    private final Clock clock = new StrictClock();
    private final int threadCount = Math.max(Runtime.getRuntime().availableProcessors(), 2);

    @Test
    public void test() {
        System.out.printf("StrictClockLongTest threadCount=%s  tickCount/thread=%s\n", this.threadCount, 10000000L);
        TestThread[] threads = this.createThreads();
        TestUtils.startAll(threads);
        TestUtils.joinAll(threads);
        long expectedTime = 10000000L * (long)this.threadCount;
        Assert.assertEquals((long)expectedTime, (long)this.clock.getTime());
    }

    public TickThread[] createThreads() {
        TickThread[] threads = new TickThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new TickThread(k);
        }
        return threads;
    }

    class TickThread
    extends TestThread {
        public TickThread(int id) {
            super("TickThread-" + id);
        }

        @Override
        public void doRun() {
            long previousTime = StrictClockLongTest.this.clock.getTime();
            for (long k = 0L; k < 10000000L; ++k) {
                long nextTime = StrictClockLongTest.this.clock.tick();
                if (nextTime <= previousTime) {
                    Assert.fail();
                }
                previousTime = nextTime;
            }
        }
    }
}

