/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.commitlock;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.DummyTransaction;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.utils.commitlock.CommitLock;
import org.multiverse.utils.commitlock.CommitLockResult;
import org.multiverse.utils.commitlock.CommitLockUtils;

public class CommitLockUtilsTest {
    @Test
    public void testNothingToLock() {
        Assert.assertTrue((boolean)CommitLockUtils.nothingToLock(null));
        Assert.assertTrue((boolean)CommitLockUtils.nothingToLock((CommitLock[])new CommitLock[0]));
        Assert.assertTrue((boolean)CommitLockUtils.nothingToLock((CommitLock[])new CommitLock[1]));
        Assert.assertFalse((boolean)CommitLockUtils.nothingToLock((CommitLock[])new CommitLock[]{new DummyCommitLock()}));
    }

    @Test(expected=NullPointerException.class)
    public void releaseLocksWithNullTransactionFails() {
        CommitLockUtils.releaseLocks((CommitLock[])new CommitLock[0], null);
    }

    @Test
    public void releaseLocksWithNullLocksSucceeds() {
        CommitLockUtils.releaseLocks(null, (Transaction)new DummyTransaction());
    }

    @Test
    public void releaseLocksWithEmptyLocksSucceeds() {
        CommitLockUtils.releaseLocks((CommitLock[])new CommitLock[0], (Transaction)new DummyTransaction());
    }

    @Test
    public void test() {
        TestUtils.testIncomplete();
    }

    class DummyCommitLock
    implements CommitLock {
        DummyCommitLock() {
        }

        public void releaseLock(Transaction expectedLockOwner) {
            throw new UnsupportedOperationException();
        }

        public CommitLockResult tryLockAndDetectConflicts(Transaction lockOwner) {
            throw new UnsupportedOperationException();
        }
    }
}

