/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.commitlock;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.DummyTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.utils.commitlock.CommitLock;
import org.multiverse.utils.commitlock.CommitLockResult;
import org.multiverse.utils.commitlock.GenericCommitLockPolicy;

public class GenericCommitLockPolicyTest {
    private GenericCommitLockPolicy policy;

    @Before
    public void setUp() {
        this.policy = new GenericCommitLockPolicy(10, 10);
    }

    @Test
    public void construction() {
        GenericCommitLockPolicy policy = new GenericCommitLockPolicy(10, 20);
        Assert.assertEquals((long)10L, (long)policy.getSpinAttemptsPerLockCount());
        Assert.assertEquals((long)20L, (long)policy.getRetryCount());
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructWithTooSmallSpinAttemptsPerLock() {
        new GenericCommitLockPolicy(-1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructWithTooSmallRetryCount() {
        new GenericCommitLockPolicy(0, -1);
    }

    @Test(expected=NullPointerException.class)
    public void tryLock_failsIfLockOwnerIsNull() {
        CommitLock commitLock = (CommitLock)Mockito.mock(CommitLock.class);
        this.policy.tryLockAndDetectConflict(commitLock, null);
    }

    @Test
    public void tryLock_succeedsWithNullLock() {
        Transaction t = (Transaction)Mockito.mock(Transaction.class);
        CommitLockResult result = this.policy.tryLockAndDetectConflict(null, t);
        Assert.assertEquals((Object)CommitLockResult.success, (Object)result);
    }

    @Test
    public void tryLock() {
        this.tryLock(CommitLockResult.success);
        this.tryLock(CommitLockResult.failure);
        this.tryLock(CommitLockResult.conflict);
    }

    public void tryLock(CommitLockResult expectedResult) {
        CommitLock commitLock = (CommitLock)Mockito.mock(CommitLock.class);
        Transaction t = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)commitLock.tryLockAndDetectConflicts(t)).thenReturn((Object)expectedResult);
        CommitLockResult result = this.policy.tryLockAndDetectConflict(commitLock, t);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void tryLockAll_nullTransactionFails() {
        this.policy.tryLockAllAndDetectConflicts(new CommitLock[0], null);
    }

    @Test
    public void tryLockAll_nullLocksSucceeds() {
        CommitLockResult result = this.policy.tryLockAllAndDetectConflicts(null, (Transaction)new DummyTransaction());
        Assert.assertEquals((Object)CommitLockResult.success, (Object)result);
    }

    @Test
    public void tryLockAll_emptyLocksSucceeds() {
        CommitLockResult result = this.policy.tryLockAllAndDetectConflicts(new CommitLock[0], (Transaction)new DummyTransaction());
        Assert.assertEquals((Object)CommitLockResult.success, (Object)result);
    }

    @Test
    public void testToString() {
        GenericCommitLockPolicy policy = new GenericCommitLockPolicy(10, 20);
        Assert.assertEquals((Object)"GenericCommitLockPolicy(retryCount=20, spinAttemptsPerLockCount=10)", (Object)policy.toString());
    }
}

