/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.monitoring;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.utils.monitoring.ProfilePublisher;
import org.multiverse.utils.profiling.ProfileCollator;

public class ProfilePublisherTest {
    private ProfileCollator collator;
    private ProfilePublisher publisher;

    @Before
    public void setUp() {
        this.collator = (ProfileCollator)Mockito.mock(ProfileCollator.class);
        this.publisher = new ProfilePublisher(this.collator);
    }

    @Test
    public void getProfileNamesReturnsCollatedNames() {
        Mockito.when((Object)this.collator.getProfileNames()).thenReturn(ProfilePublisherTest.asSet("James", "Bond"));
        Object[] profileNames = this.publisher.getProfileNames();
        Arrays.sort(profileNames);
        Assert.assertArrayEquals((Object[])new String[]{"Bond", "James"}, (Object[])profileNames);
    }

    private static <E> Set<E> asSet(E ... elems) {
        return new HashSet<E>(Arrays.asList(elems));
    }

    @Test
    public void getStatisticsForUnknownProfileReturnsMessage() {
        String unknownProfileName = "unknown";
        Mockito.when((Object)this.collator.getProfilePage(unknownProfileName)).thenReturn(null);
        ProfilePublisherTest.assertStringContains(this.publisher.getStatistics(unknownProfileName), unknownProfileName);
    }

    private static void assertStringContains(String total, String ... sections) {
        for (String section : sections) {
            Assert.assertTrue((String)String.format("Expected '%s' to contain '%s'", total, section), (boolean)total.contains(section));
        }
    }

    @Test
    public void KeyedProfilePage_toStringContainsProfilePageData() {
        String profileName = "agents";
        HashMap<String, List<Long>> stats = new HashMap<String, List<Long>>();
        stats.put("007", Arrays.asList(53L, 49L, null));
        StubKeyedProfilePage page = new StubKeyedProfilePage(profileName, Arrays.asList("#missions", "#kills"), stats);
        ProfilePublisherTest.assertStringContains(page.toString(), "#missions", "#kills", "007", "53", "49");
    }

    @Test
    public void writeToStreamOnlyWritesProfilePageData() throws IOException {
        ProfileCollator.ProfilePage page = (ProfileCollator.ProfilePage)Mockito.mock(ProfileCollator.ProfilePage.class);
        Mockito.when((Object)page.toString()).thenReturn((Object)"James Bond");
        Mockito.when((Object)this.collator.getProfilePages()).thenReturn(ProfilePublisherTest.asSet(page));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.publisher.writeStatisticsToStream((OutputStream)stream);
        Assert.assertTrue((String)"Expected stream to start with 'James Bond'", (boolean)stream.toString().startsWith("James Bond"));
    }

    private static class StubKeyedProfilePage
    extends ProfilePublisher.KeyedProfilePage<Object> {
        private StubKeyedProfilePage(String name, List<String> statLabels, Map<Object, List<Long>> stats) {
            super(name, statLabels, stats);
        }

        protected String getFormattedKeyLabels() {
            return "";
        }

        protected String toFormattedString(Object key) {
            return key.toString();
        }
    }
}

