/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.profiling;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.utils.profiling.SimpleProfileRepository;

public class SimpleProfileRepositoryPrinter {
    public static String toPrettyString(SimpleProfileRepository repository) {
        StringBuilder pretty = new StringBuilder("Profiler data\n=============\n");
        Comparator<Map.Entry<String, AtomicLong>> sortOnKey = new Comparator<Map.Entry<String, AtomicLong>>(){

            @Override
            public int compare(Map.Entry<String, AtomicLong> o1, Map.Entry<String, AtomicLong> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        };
        SimpleProfileRepositoryPrinter.appendPrettyString(pretty, SimpleProfileRepositoryPrinter.getSingleKeys(repository), sortOnKey, "Single keys");
        Comparator<Map.Entry<SimpleProfileRepository.ComposedKey, AtomicLong>> sortOnKey2ThenKey1 = new Comparator<Map.Entry<SimpleProfileRepository.ComposedKey, AtomicLong>>(){

            @Override
            public int compare(Map.Entry<SimpleProfileRepository.ComposedKey, AtomicLong> o1, Map.Entry<SimpleProfileRepository.ComposedKey, AtomicLong> o2) {
                int compareKey2s = o1.getKey().key2.compareTo(o2.getKey().key2);
                return compareKey2s != 0 ? compareKey2s : o1.getKey().key1.compareTo(o2.getKey().key1);
            }
        };
        SimpleProfileRepositoryPrinter.appendPrettyString(pretty, SimpleProfileRepositoryPrinter.getComposedKeys(repository), sortOnKey2ThenKey1, "Composed keys", new ToStringTransformer<SimpleProfileRepository.ComposedKey>(){

            @Override
            public String toString(SimpleProfileRepository.ComposedKey composed) {
                return String.format("(%s) %s", composed.key2, composed.key1);
            }
        });
        return pretty.toString();
    }

    private static <K, V> StringBuilder appendPrettyString(StringBuilder builder, Map<K, V> map, Comparator<Map.Entry<K, V>> entryComparator, String title) {
        return SimpleProfileRepositoryPrinter.appendPrettyString(builder, map, entryComparator, title, new ToStringTransformer<K>(){

            @Override
            public String toString(K obj) {
                return obj.toString();
            }
        });
    }

    private static <K, V> StringBuilder appendPrettyString(StringBuilder builder, Map<K, V> map, Comparator<Map.Entry<K, V>> entryComparator, String title, ToStringTransformer<K> keyToString) {
        if (map.isEmpty()) {
            builder.append("<no ").append(title.toLowerCase()).append(">\n");
        } else {
            builder.append(title).append("\n").append(title.replaceAll(".", "-")).append("\n");
            ArrayList<Map.Entry<K, V>> sortedEntries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
            Collections.sort(sortedEntries, entryComparator);
            for (Map.Entry entry : sortedEntries) {
                builder.append(keyToString.toString(entry.getKey())).append(" = ").append(entry.getValue()).append("\n");
            }
        }
        return builder.append("\n");
    }

    private static Map<String, AtomicLong> getSingleKeys(SimpleProfileRepository repository) {
        return (Map)SimpleProfileRepositoryPrinter.getFieldValue(repository, "singleKeyMap");
    }

    private static Map<SimpleProfileRepository.ComposedKey, AtomicLong> getComposedKeys(SimpleProfileRepository repository) {
        return (Map)SimpleProfileRepositoryPrinter.getFieldValue(repository, "map");
    }

    private static <T> T getFieldValue(SimpleProfileRepository repository, String fieldName) {
        try {
            Field field = SimpleProfileRepository.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(repository);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Unable to get value for field %s of target %s due to: ", fieldName, repository), exception);
        }
    }

    private static interface ToStringTransformer<T> {
        public String toString(T var1);
    }
}

