/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.restartbackoff;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.multiverse.utils.restartbackoff.ExponentialRestartBackoffPolicy;

public class ExponentialRestartBackoffPolicyTest {
    @Test
    public void construction_INSTANCE() {
        ExponentialRestartBackoffPolicy policy = ExponentialRestartBackoffPolicy.INSTANCE_10_MS_MAX;
        Assert.assertEquals((long)1000L, (long)policy.getMinDelayNs());
        Assert.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(10L), (long)policy.getMaxDelayNs());
    }

    @Test(expected=IllegalArgumentException.class)
    public void minimumDelayCantBeLargerThanMaximumDelay() {
        new ExponentialRestartBackoffPolicy(10L, 9L, TimeUnit.NANOSECONDS);
    }

    @Test
    public void noDelayForZeroIteration() {
        ExponentialRestartBackoffPolicy policy = new ExponentialRestartBackoffPolicy();
        long delayNs = policy.calcDelayNs(0);
        Assert.assertEquals((long)policy.getMinDelayNs(), (long)delayNs);
    }

    @Test
    public void minimumDelay() {
        long minDelay = 10000L;
        ExponentialRestartBackoffPolicy policy = new ExponentialRestartBackoffPolicy(minDelay, 1L, TimeUnit.SECONDS);
        long delayNs = policy.calcDelayNs(1);
        Assert.assertEquals((long)minDelay, (long)delayNs);
    }

    @Test
    public void tooLargeValueTruncated() {
        long maxDelayNs = 10000L;
        ExponentialRestartBackoffPolicy policy = new ExponentialRestartBackoffPolicy(100L, maxDelayNs, TimeUnit.NANOSECONDS);
        long delayNs = policy.calcDelayNs(100);
        Assert.assertEquals((long)maxDelayNs, (long)delayNs);
    }

    @Test
    public void happyFlow() {
        long maxDelayNs = 1000000L;
        ExponentialRestartBackoffPolicy policy = new ExponentialRestartBackoffPolicy(100L, maxDelayNs, TimeUnit.NANOSECONDS);
        Assert.assertEquals((long)1024L, (long)policy.calcDelayNs(10));
        Assert.assertEquals((long)4096L, (long)policy.calcDelayNs(12));
    }

    @Test
    public void sleep() throws InterruptedException {
        long sleepNs = TimeUnit.MILLISECONDS.toNanos(100L);
        long startNs = System.nanoTime();
        ExponentialRestartBackoffPolicy.sleep((long)sleepNs);
        long elapsedNs = System.nanoTime() - startNs;
        Assert.assertTrue(((double)elapsedNs > 0.95 * (double)sleepNs ? 1 : 0) != 0);
    }
}

