/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import org.multiverse.api.Stm;
import org.multiverse.utils.monitoring.ProfilePublisher;
import org.multiverse.utils.monitoring.jmx.JmxUtils;
import org.multiverse.utils.profiling.ProfilerAware;

public final class GlobalStmInstance {
    private static final String KEY = GlobalStmInstance.class.getName() + ".factoryMethod";
    private static final String DEFAULT_FACTORY_METHOD = "org.multiverse.stms.alpha.AlphaStm.createDebug";
    private static final Logger logger = Logger.getLogger(GlobalStmInstance.class.getName());
    private static volatile Stm instance;

    private static Method getMethod(String factoryMethod) {
        Method method;
        Class<?> clazz;
        int indexOf = factoryMethod.lastIndexOf(".");
        if (indexOf == -1) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'. It is not a valid factory method, it should be something like 'com.SomeStm.createSomeStm').", KEY, factoryMethod);
            logger.info(msg);
            throw new IllegalArgumentException();
        }
        String className = factoryMethod.substring(0, indexOf);
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'.'%s' is not an existing class (it can't be found using the Thread.currentThread.getContextClassLoader).", KEY, className, factoryMethod);
            logger.info(msg);
            throw new IllegalArgumentException(msg, e);
        }
        String methodName = factoryMethod.substring(indexOf + 1);
        if (methodName.length() == 0) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'.The factory method is completely missing, it should be something like %s.createSomeStm.", KEY, className, factoryMethod);
            logger.info(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'.The factory method is not found. Remember that it should not have any arguments.", KEY, factoryMethod);
            logger.info(msg);
            throw new IllegalArgumentException(msg, e);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'.The factory method is not static.", KEY, factoryMethod);
            logger.info(msg);
            throw new IllegalArgumentException(msg);
        }
        return method;
    }

    public static Stm getGlobalStmInstance() {
        return instance;
    }

    public static void setGlobalStmInstance(Stm newInstance) {
        if (newInstance == null) {
            throw new NullPointerException();
        }
        GlobalStmInstance.doSomeLogging();
        instance = newInstance;
    }

    private static void doSomeLogging() {
        Stm oldInstance = instance;
        if (oldInstance != null && oldInstance.getTime() > 0L) {
            logger.warning("Replacing a used global STM instance. The old STM instance already has commits and this could lead to strange concurrency bugs. Normally this situation should be prevented. The safest thing to do is to drop all atomicobjects that have been created while using that STM.");
        } else {
            logger.info("Replacing unused GlobalStmInstance");
        }
    }

    private GlobalStmInstance() {
    }

    static {
        String factoryMethod = System.getProperty(KEY, DEFAULT_FACTORY_METHOD);
        logger.info(String.format("Initializing GlobalStmInstance using factoryMethod '%s'.", factoryMethod));
        try {
            Method method = GlobalStmInstance.getMethod(factoryMethod);
            instance = (Stm)method.invoke(null, new Object[0]);
            logger.info(String.format("Successfully initialized GlobalStmInstance using factoryMethod '%s'.", factoryMethod));
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'.'%s' is not accessable (it should be public)').", KEY, factoryMethod, factoryMethod);
            logger.severe(msg);
            throw new IllegalArgumentException(msg, e);
        }
        catch (ClassCastException e) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'.'%s' is not accessable (it should be public)').", KEY, factoryMethod, factoryMethod);
            logger.severe(msg);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("Failed to initialize GlobalStmInstance through System property '%s' with value '%s'.'%s' failed to be invoked.", KEY, factoryMethod, factoryMethod);
            logger.severe(msg);
            throw new IllegalArgumentException(msg, e);
        }
        if (instance instanceof ProfilerAware) {
            ProfilePublisher publisher = new ProfilePublisher(((ProfilerAware)((Object)instance)).getProfiler().getCollator());
            String mBeanName = JmxUtils.registerMBean(publisher);
            logger.info(String.format("Successfully registered '%s' as an MBean under name '%s'", publisher, mBeanName));
        }
    }
}

