/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.multiverse.api.ScheduleType;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.RetryError;

public final class StmUtils {
    public static void retry() {
        ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        throw RetryError.create();
    }

    public static void deferredExecute(Runnable task) {
        Transaction t = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        t.schedule(task, ScheduleType.postCommit);
    }

    public static void compensatingExecute(Runnable task) {
        Transaction t = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        t.schedule(task, ScheduleType.postAbort);
    }

    private StmUtils() {
    }
}

